/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javaemul.internal.InternalPreconditions;

public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional<Object>(null);
    private final T ref;

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(InternalPreconditions.checkCriticalNotNull(value));
    }

    public static <T> Optional<T> ofNullable(T value) {
        return value == null ? Optional.empty() : Optional.of(value);
    }

    private Optional(T ref) {
        this.ref = ref;
    }

    public boolean isPresent() {
        return this.ref != null;
    }

    public boolean isEmpty() {
        return this.ref == null;
    }

    public T get() {
        InternalPreconditions.checkCriticalElement(this.isPresent());
        return this.ref;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.ref);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> consumer, Runnable emptyConsumer) {
        if (this.isPresent()) {
            consumer.accept(this.ref);
        } else {
            emptyConsumer.run();
        }
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        InternalPreconditions.checkNotNull(predicate);
        if (!this.isPresent() || predicate.test(this.ref)) {
            return this;
        }
        return Optional.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        InternalPreconditions.checkNotNull(mapper);
        if (this.isPresent()) {
            return Optional.ofNullable(mapper.apply(this.ref));
        }
        return Optional.empty();
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        InternalPreconditions.checkNotNull(mapper);
        if (this.isPresent()) {
            return InternalPreconditions.checkNotNull(mapper.apply(this.ref));
        }
        return Optional.empty();
    }

    public Optional<T> or(Supplier<? extends Optional<? extends T>> supplier) {
        InternalPreconditions.checkNotNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Optional<? extends T> r = supplier.get();
        return InternalPreconditions.checkNotNull(r);
    }

    public T orElse(T other) {
        return this.isPresent() ? this.ref : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.isPresent() ? this.ref : other.get();
    }

    public T orElseThrow() {
        return this.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.ref;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public Stream<T> stream() {
        if (this.isPresent()) {
            return Stream.of(this.ref);
        }
        return Stream.empty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Objects.equals(this.ref, other.ref);
    }

    public int hashCode() {
        return Objects.hashCode(this.ref);
    }

    public String toString() {
        return this.isPresent() ? "Optional.of(" + String.valueOf(this.ref) + ")" : "Optional.empty()";
    }
}

