/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javaemul.internal.InternalPreconditions;

public final class OptionalInt {
    private static final OptionalInt EMPTY = new OptionalInt();
    private final int ref;
    private final boolean present;

    public static OptionalInt empty() {
        return EMPTY;
    }

    public static OptionalInt of(int value) {
        return new OptionalInt(value);
    }

    private OptionalInt() {
        this.ref = 0;
        this.present = false;
    }

    private OptionalInt(int value) {
        this.ref = value;
        this.present = true;
    }

    public boolean isPresent() {
        return this.present;
    }

    public boolean isEmpty() {
        return !this.present;
    }

    public int getAsInt() {
        InternalPreconditions.checkCriticalElement(this.present);
        return this.ref;
    }

    public void ifPresent(IntConsumer consumer) {
        if (this.present) {
            consumer.accept(this.ref);
        }
    }

    public void ifPresentOrElse(IntConsumer action, Runnable emptyAction) {
        if (this.present) {
            action.accept(this.ref);
        } else {
            emptyAction.run();
        }
    }

    public int orElse(int other) {
        return this.present ? this.ref : other;
    }

    public int orElseGet(IntSupplier other) {
        return this.present ? this.ref : other.getAsInt();
    }

    public int orElseThrow() {
        return this.getAsInt();
    }

    public <X extends Throwable> int orElseThrow(Supplier<X> exceptionSupplier) throws X {
        if (this.present) {
            return this.ref;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public IntStream stream() {
        if (this.present) {
            return IntStream.of(this.ref);
        }
        return IntStream.empty();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OptionalInt)) {
            return false;
        }
        OptionalInt other = (OptionalInt)obj;
        return this.present == other.present && Integer.compare(this.ref, other.ref) == 0;
    }

    public int hashCode() {
        return this.present ? Integer.hashCode(this.ref) : 0;
    }

    public String toString() {
        return this.present ? "OptionalInt.of(" + Integer.toString(this.ref) + ")" : "OptionalInt.empty()";
    }
}

