/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import javaemul.internal.InternalPreconditions;

public class Random {
    private static final double multiplierHi = 1502.0;
    private static final double multiplierLo = 1.5525485E7;
    private static final double twoToThe24 = 1.6777216E7;
    private static final double twoToThe31 = 2.147483648E9;
    private static final double twoToThe32 = 4.294967296E9;
    private static final double twoToTheMinus24 = 5.960464477539063E-8;
    private static final double twoToTheMinus26 = 1.4901161193847656E-8;
    private static final double twoToTheMinus31 = 4.656612873077393E-10;
    private static final double twoToTheMinus53 = (double)1.110223E-16f;
    private static final double[] twoToTheXMinus24 = new double[25];
    private static final double[] twoToTheXMinus48 = new double[33];
    private static int uniqueSeed = 0;
    private boolean haveNextNextGaussian = false;
    private double nextNextGaussian;
    private double seedhi;
    private double seedlo;

    public Random() {
        double seed = (double)uniqueSeed++ + System.currentTimeMillisAsDouble();
        int hi = (int)Math.floor(seed * 5.960464477539063E-8) & 0xFFFFFF;
        int lo = (int)(seed - (double)hi * 1.6777216E7);
        this.setSeed(hi, lo);
    }

    public Random(long seed) {
        this.setSeed(seed);
    }

    public boolean nextBoolean() {
        return this.nextInternal(1) != 0.0;
    }

    public void nextBytes(byte[] buf) {
        InternalPreconditions.checkNotNull(buf);
        int rand = 0;
        int count = 0;
        int loop = 0;
        while (count < buf.length) {
            if (loop == 0) {
                rand = (int)this.nextInternal(32);
                loop = 3;
            } else {
                --loop;
            }
            buf[count++] = (byte)rand;
            rand >>= 8;
        }
    }

    public double nextDouble() {
        return this.nextInternal(26) * 1.4901161193847656E-8 + this.nextInternal(27) * (double)1.110223E-16f;
    }

    public float nextFloat() {
        return (float)(this.nextInternal(24) * 5.960464477539063E-8);
    }

    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0) {
        }
        double norm = s == 0.0 ? 0.0 : Math.sqrt(-2.0 * Math.log(s) / s);
        this.nextNextGaussian = v2 * norm;
        this.haveNextNextGaussian = true;
        return v1 * norm;
    }

    public int nextInt() {
        return (int)this.nextInternal(32);
    }

    public int nextInt(int n) {
        double val;
        double bits;
        InternalPreconditions.checkCriticalArgument(n > 0);
        if ((n & -n) == n) {
            return (int)((double)n * this.nextInternal(31) * 4.656612873077393E-10);
        }
        while ((bits = this.nextInternal(31)) - (val = bits % (double)n) + (double)(n - 1) < 0.0) {
        }
        return (int)val;
    }

    public long nextLong() {
        return ((long)this.nextInternal(32) << 32) + (long)this.nextInternal(32);
    }

    public synchronized void setSeed(long seed) {
        this.setSeed((int)(seed >> 24 & 0xFFFFFFL), (int)(seed & 0xFFFFFFL));
    }

    protected synchronized int next(int bits) {
        return (int)this.nextInternal(bits);
    }

    private synchronized double nextInternal(int bits) {
        double hi = this.seedhi * 1.5525485E7 + this.seedlo * 1502.0;
        double lo = this.seedlo * 1.5525485E7 + 11.0;
        double carry = Math.floor(lo * 5.960464477539063E-8);
        hi += carry;
        this.seedhi = hi %= 1.6777216E7;
        this.seedlo = lo -= carry * 1.6777216E7;
        if (bits <= 24) {
            return Math.floor(this.seedhi * twoToTheXMinus24[bits]);
        }
        double h = this.seedhi * (double)(1 << bits - 24);
        double l = Math.floor(this.seedlo * twoToTheXMinus48[bits]);
        double dval = h + l;
        if (dval >= 2.147483648E9) {
            dval -= 4.294967296E9;
        }
        return dval;
    }

    private synchronized void setSeed(int seedhi, int seedlo) {
        this.seedhi = seedhi ^ 0x5DE;
        this.seedlo = seedlo ^ 0xECE66D;
        this.haveNextNextGaussian = false;
    }

    static {
        double twoToTheXMinus48Tmp = 1.52587890625E-5;
        for (int i = 32; i >= 0; --i) {
            Random.twoToTheXMinus48[i] = twoToTheXMinus48Tmp;
            twoToTheXMinus48Tmp *= 0.5;
        }
        double twoToTheXMinus24Tmp = 1.0;
        for (int i = 24; i >= 0; --i) {
            Random.twoToTheXMinus24[i] = twoToTheXMinus24Tmp;
            twoToTheXMinus24Tmp *= 0.5;
        }
    }
}

