/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import javaemul.internal.InternalPreconditions;

public final class Spliterators {
    public static <T> Spliterator<T> emptySpliterator() {
        return EmptySpliterator.OF_REF;
    }

    public static Spliterator.OfDouble emptyDoubleSpliterator() {
        return EmptySpliterator.OF_DOUBLE;
    }

    public static Spliterator.OfInt emptyIntSpliterator() {
        return EmptySpliterator.OF_INT;
    }

    public static Spliterator.OfLong emptyLongSpliterator() {
        return EmptySpliterator.OF_LONG;
    }

    public static <T> Spliterator<T> spliterator(Object[] array, int characteristics) {
        return new ArraySpliterator(array, characteristics);
    }

    public static <T> Spliterator<T> spliterator(Object[] array, int fromIndex, int toIndex, int characteristics) {
        Spliterators.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        return new ArraySpliterator(array, fromIndex, toIndex, characteristics);
    }

    public static Spliterator.OfInt spliterator(int[] array, int characteristics) {
        return new IntArraySpliterator(array, characteristics);
    }

    public static Spliterator.OfInt spliterator(int[] array, int fromIndex, int toIndex, int characteristics) {
        Spliterators.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        return new IntArraySpliterator(array, fromIndex, toIndex, characteristics);
    }

    public static Spliterator.OfLong spliterator(long[] array, int characteristics) {
        return new LongArraySpliterator(array, characteristics);
    }

    public static Spliterator.OfLong spliterator(long[] array, int fromIndex, int toIndex, int characteristics) {
        Spliterators.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        return new LongArraySpliterator(array, fromIndex, toIndex, characteristics);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int characteristics) {
        return new DoubleArraySpliterator(array, characteristics);
    }

    public static Spliterator.OfDouble spliterator(double[] array, int fromIndex, int toIndex, int characteristics) {
        Spliterators.checkCriticalArrayBounds(fromIndex, toIndex, array.length);
        return new DoubleArraySpliterator(array, fromIndex, toIndex, characteristics);
    }

    public static <T> Spliterator<T> spliterator(Collection<? extends T> c, int characteristics) {
        return new IteratorSpliterator<T>(c, characteristics);
    }

    public static <T> Spliterator<T> spliterator(Iterator<? extends T> it, long size, int characteristics) {
        return new IteratorSpliterator<T>(it, size, characteristics);
    }

    public static <T> Spliterator<T> spliteratorUnknownSize(Iterator<? extends T> it, int characteristics) {
        return new IteratorSpliterator<T>(it, characteristics);
    }

    public static Spliterator.OfInt spliterator(PrimitiveIterator.OfInt it, long size, int characteristics) {
        return new IntIteratorSpliterator(it, size, characteristics);
    }

    public static Spliterator.OfInt spliteratorUnknownSize(PrimitiveIterator.OfInt it, int characteristics) {
        return new IntIteratorSpliterator(it, characteristics);
    }

    public static Spliterator.OfLong spliterator(PrimitiveIterator.OfLong it, long size, int characteristics) {
        return new LongIteratorSpliterator(it, size, characteristics);
    }

    public static Spliterator.OfLong spliteratorUnknownSize(PrimitiveIterator.OfLong it, int characteristics) {
        return new LongIteratorSpliterator(it, characteristics);
    }

    public static Spliterator.OfDouble spliterator(PrimitiveIterator.OfDouble it, long size, int characteristics) {
        return new DoubleIteratorSpliterator(it, size, characteristics);
    }

    public static Spliterator.OfDouble spliteratorUnknownSize(PrimitiveIterator.OfDouble it, int characteristics) {
        return new DoubleIteratorSpliterator(it, characteristics);
    }

    public static <T> Iterator<T> iterator(Spliterator<? extends T> spliterator) {
        return new ConsumerIterator<T>(spliterator);
    }

    public static PrimitiveIterator.OfDouble iterator(Spliterator.OfDouble spliterator) {
        return new DoubleConsumerIterator(spliterator);
    }

    public static PrimitiveIterator.OfInt iterator(Spliterator.OfInt spliterator) {
        return new IntConsumerIterator(spliterator);
    }

    public static PrimitiveIterator.OfLong iterator(Spliterator.OfLong spliterator) {
        return new LongConsumerIterator(spliterator);
    }

    private static void checkSorted(int characteristics) {
        InternalPreconditions.checkCriticalState((characteristics & 4) != 0);
    }

    private static int sizeKnownSpliteratorCharacteristics(int characteristics) {
        return characteristics | 0x40 | 0x4000;
    }

    private static int sizeKnownIteratorSpliteratorCharacteristics(int characteristics) {
        return (characteristics & 0x1000) == 0 ? Spliterators.sizeKnownSpliteratorCharacteristics(characteristics) : characteristics;
    }

    private static int sizeUnknownSpliteratorCharacteristics(int characteristics) {
        return characteristics & 0xFFFFBFBF;
    }

    private static void checkCriticalArrayBounds(int start, int end, int length) {
        if (start > end || start < 0 || end > length) {
            throw new ArrayIndexOutOfBoundsException("fromIndex: " + start + ", toIndex: " + end + ", length: " + length);
        }
    }

    private Spliterators() {
    }

    private static final class LongArraySpliterator
    extends BaseArraySpliterator<Long, Spliterator.OfLong, LongConsumer>
    implements Spliterator.OfLong {
        private final long[] array;

        LongArraySpliterator(long[] array, int characteristics) {
            this(array, 0, array.length, characteristics);
        }

        LongArraySpliterator(long[] array, int from, int limit, int characteristics) {
            super(from, limit, characteristics);
            this.array = array;
        }

        @Override
        protected void consume(LongConsumer consumer, int index) {
            consumer.accept(this.array[index]);
        }
    }

    private static final class IntArraySpliterator
    extends BaseArraySpliterator<Integer, Spliterator.OfInt, IntConsumer>
    implements Spliterator.OfInt {
        private final int[] array;

        IntArraySpliterator(int[] array, int characteristics) {
            this(array, 0, array.length, characteristics);
        }

        IntArraySpliterator(int[] array, int from, int limit, int characteristics) {
            super(from, limit, characteristics);
            this.array = array;
        }

        @Override
        protected void consume(IntConsumer consumer, int index) {
            consumer.accept(this.array[index]);
        }
    }

    private static final class DoubleArraySpliterator
    extends BaseArraySpliterator<Double, Spliterator.OfDouble, DoubleConsumer>
    implements Spliterator.OfDouble {
        private final double[] array;

        DoubleArraySpliterator(double[] array, int characteristics) {
            this(array, 0, array.length, characteristics);
        }

        DoubleArraySpliterator(double[] array, int from, int limit, int characteristics) {
            super(from, limit, characteristics);
            this.array = array;
        }

        @Override
        protected void consume(DoubleConsumer consumer, int index) {
            consumer.accept(this.array[index]);
        }
    }

    private static final class ArraySpliterator<T>
    extends BaseArraySpliterator<T, Spliterator<T>, Consumer<? super T>>
    implements Spliterator<T> {
        private final Object[] array;

        ArraySpliterator(Object[] array, int characteristics) {
            this(array, 0, array.length, characteristics);
        }

        ArraySpliterator(Object[] array, int from, int limit, int characteristics) {
            super(from, limit, characteristics);
            this.array = array;
        }

        @Override
        protected void consume(Consumer<? super T> consumer, int index) {
            consumer.accept(this.array[index]);
        }
    }

    private static abstract class BaseArraySpliterator<T, S extends Spliterator<T>, C>
    implements Spliterator<T> {
        private int index;
        private final int limit;
        private final int characteristics;

        BaseArraySpliterator(int from, int limit, int characteristics) {
            this.index = from;
            this.limit = limit;
            this.characteristics = Spliterators.sizeKnownSpliteratorCharacteristics(characteristics);
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long estimateSize() {
            return this.limit - this.index;
        }

        public void forEachRemaining(C consumer) {
            InternalPreconditions.checkNotNull(consumer);
            while (this.index < this.limit) {
                this.consume(consumer, this.index++);
            }
        }

        @Override
        public Comparator<? super T> getComparator() {
            Spliterators.checkSorted(this.characteristics);
            return null;
        }

        public boolean tryAdvance(C consumer) {
            InternalPreconditions.checkNotNull(consumer);
            if (this.index < this.limit) {
                this.consume(consumer, this.index++);
                return true;
            }
            return false;
        }

        public S trySplit() {
            return null;
        }

        protected abstract void consume(C var1, int var2);
    }

    private static final class LongIteratorSpliterator
    extends AbstractLongSpliterator {
        private final PrimitiveIterator.OfLong it;

        LongIteratorSpliterator(PrimitiveIterator.OfLong it, long size, int characteristics) {
            super(size, Spliterators.sizeKnownIteratorSpliteratorCharacteristics(characteristics));
            this.it = InternalPreconditions.checkNotNull(it);
        }

        LongIteratorSpliterator(PrimitiveIterator.OfLong it, int characteristics) {
            super(Long.MAX_VALUE, Spliterators.sizeUnknownSpliteratorCharacteristics(characteristics));
            this.it = InternalPreconditions.checkNotNull(it);
        }

        @Override
        public void forEachRemaining(LongConsumer consumer) {
            this.it.forEachRemaining(consumer);
        }

        @Override
        public Comparator<? super Long> getComparator() {
            Spliterators.checkSorted(this.characteristics());
            return null;
        }

        @Override
        public boolean tryAdvance(LongConsumer consumer) {
            InternalPreconditions.checkNotNull(consumer);
            if (this.it.hasNext()) {
                consumer.accept(this.it.nextLong());
                return true;
            }
            return false;
        }
    }

    private static final class IntIteratorSpliterator
    extends AbstractIntSpliterator {
        private final PrimitiveIterator.OfInt it;

        IntIteratorSpliterator(PrimitiveIterator.OfInt it, long size, int characteristics) {
            super(size, Spliterators.sizeKnownIteratorSpliteratorCharacteristics(characteristics));
            this.it = InternalPreconditions.checkNotNull(it);
        }

        IntIteratorSpliterator(PrimitiveIterator.OfInt it, int characteristics) {
            super(Long.MAX_VALUE, Spliterators.sizeUnknownSpliteratorCharacteristics(characteristics));
            this.it = InternalPreconditions.checkNotNull(it);
        }

        @Override
        public void forEachRemaining(IntConsumer consumer) {
            this.it.forEachRemaining(consumer);
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            Spliterators.checkSorted(this.characteristics());
            return null;
        }

        @Override
        public boolean tryAdvance(IntConsumer consumer) {
            InternalPreconditions.checkNotNull(consumer);
            if (this.it.hasNext()) {
                consumer.accept(this.it.nextInt());
                return true;
            }
            return false;
        }
    }

    private static final class DoubleIteratorSpliterator
    extends AbstractDoubleSpliterator {
        private final PrimitiveIterator.OfDouble it;

        DoubleIteratorSpliterator(PrimitiveIterator.OfDouble it, long size, int characteristics) {
            super(size, Spliterators.sizeKnownIteratorSpliteratorCharacteristics(characteristics));
            this.it = InternalPreconditions.checkNotNull(it);
        }

        DoubleIteratorSpliterator(PrimitiveIterator.OfDouble it, int characteristics) {
            super(Long.MAX_VALUE, Spliterators.sizeUnknownSpliteratorCharacteristics(characteristics));
            this.it = InternalPreconditions.checkNotNull(it);
        }

        @Override
        public void forEachRemaining(DoubleConsumer consumer) {
            this.it.forEachRemaining(consumer);
        }

        @Override
        public Comparator<? super Double> getComparator() {
            Spliterators.checkSorted(this.characteristics());
            return null;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer consumer) {
            InternalPreconditions.checkNotNull(consumer);
            if (this.it.hasNext()) {
                consumer.accept(this.it.nextDouble());
                return true;
            }
            return false;
        }
    }

    static class IteratorSpliterator<T>
    implements Spliterator<T> {
        private Collection<? extends T> collection;
        private Iterator<? extends T> it;
        private final int characteristics;
        private long estimateSize;

        IteratorSpliterator(Collection<? extends T> collection, int characteristics) {
            this.collection = InternalPreconditions.checkNotNull(collection);
            this.characteristics = Spliterators.sizeKnownIteratorSpliteratorCharacteristics(characteristics);
        }

        IteratorSpliterator(Iterator<? extends T> it, long size, int characteristics) {
            this.it = InternalPreconditions.checkNotNull(it);
            this.characteristics = Spliterators.sizeKnownIteratorSpliteratorCharacteristics(characteristics);
            this.estimateSize = size;
        }

        IteratorSpliterator(Iterator<? extends T> it, int characteristics) {
            this.it = InternalPreconditions.checkNotNull(it);
            this.characteristics = Spliterators.sizeUnknownSpliteratorCharacteristics(characteristics);
            this.estimateSize = Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long estimateSize() {
            this.initIterator();
            return this.estimateSize;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            this.initIterator();
            this.it.forEachRemaining(consumer);
        }

        @Override
        public Comparator<? super T> getComparator() {
            Spliterators.checkSorted(this.characteristics);
            return null;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            InternalPreconditions.checkNotNull(consumer);
            this.initIterator();
            if (this.it.hasNext()) {
                consumer.accept(this.it.next());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<T> trySplit() {
            return null;
        }

        private void initIterator() {
            if (this.it == null) {
                this.it = this.collection.iterator();
                this.estimateSize = this.collection.size();
            }
        }
    }

    private static final class LongConsumerIterator
    implements LongConsumer,
    PrimitiveIterator.OfLong {
        private final Spliterator.OfLong spliterator;
        private long nextElement;
        private boolean hasElement = false;

        LongConsumerIterator(Spliterator.OfLong spliterator) {
            this.spliterator = InternalPreconditions.checkNotNull(spliterator);
        }

        @Override
        public void accept(long l) {
            this.nextElement = l;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasElement) {
                this.hasElement = this.spliterator.tryAdvance(this);
            }
            return this.hasElement;
        }

        @Override
        public long nextLong() {
            InternalPreconditions.checkCriticalElement(this.hasNext());
            this.hasElement = false;
            return this.nextElement;
        }
    }

    private static final class IntConsumerIterator
    implements IntConsumer,
    PrimitiveIterator.OfInt {
        private final Spliterator.OfInt spliterator;
        private int nextElement;
        private boolean hasElement = false;

        IntConsumerIterator(Spliterator.OfInt spliterator) {
            this.spliterator = InternalPreconditions.checkNotNull(spliterator);
        }

        @Override
        public void accept(int i) {
            this.nextElement = i;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasElement) {
                this.hasElement = this.spliterator.tryAdvance(this);
            }
            return this.hasElement;
        }

        @Override
        public int nextInt() {
            InternalPreconditions.checkCriticalElement(this.hasNext());
            this.hasElement = false;
            return this.nextElement;
        }
    }

    private static final class DoubleConsumerIterator
    implements DoubleConsumer,
    PrimitiveIterator.OfDouble {
        private final Spliterator.OfDouble spliterator;
        private double nextElement;
        private boolean hasElement = false;

        DoubleConsumerIterator(Spliterator.OfDouble spliterator) {
            this.spliterator = InternalPreconditions.checkNotNull(spliterator);
        }

        @Override
        public void accept(double d) {
            this.nextElement = d;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasElement) {
                this.hasElement = this.spliterator.tryAdvance(this);
            }
            return this.hasElement;
        }

        @Override
        public double nextDouble() {
            InternalPreconditions.checkCriticalElement(this.hasNext());
            this.hasElement = false;
            return this.nextElement;
        }
    }

    private static final class ConsumerIterator<T>
    implements Consumer<T>,
    Iterator<T> {
        private final Spliterator<? extends T> spliterator;
        private T nextElement;
        private boolean hasElement = false;

        ConsumerIterator(Spliterator<? extends T> spliterator) {
            this.spliterator = InternalPreconditions.checkNotNull(spliterator);
        }

        @Override
        public void accept(T element) {
            this.nextElement = element;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasElement) {
                this.hasElement = this.spliterator.tryAdvance(this);
            }
            return this.hasElement;
        }

        @Override
        public T next() {
            InternalPreconditions.checkCriticalElement(this.hasNext());
            this.hasElement = false;
            T element = this.nextElement;
            this.nextElement = null;
            return element;
        }
    }

    private static abstract class EmptySpliterator<T, S extends Spliterator<T>, C>
    implements Spliterator<T> {
        static final Spliterator<Object> OF_REF = new OfRef<Object>();
        static final Spliterator.OfDouble OF_DOUBLE = new OfDouble();
        static final Spliterator.OfInt OF_INT = new OfInt();
        static final Spliterator.OfLong OF_LONG = new OfLong();

        private EmptySpliterator() {
        }

        @Override
        public int characteristics() {
            return 16448;
        }

        @Override
        public long estimateSize() {
            return 0L;
        }

        public void forEachRemaining(C consumer) {
            InternalPreconditions.checkNotNull(consumer);
        }

        public boolean tryAdvance(C consumer) {
            InternalPreconditions.checkNotNull(consumer);
            return false;
        }

        public S trySplit() {
            return null;
        }

        private static final class OfLong
        extends EmptySpliterator<Long, Spliterator.OfLong, LongConsumer>
        implements Spliterator.OfLong {
            OfLong() {
            }
        }

        private static final class OfInt
        extends EmptySpliterator<Integer, Spliterator.OfInt, IntConsumer>
        implements Spliterator.OfInt {
            OfInt() {
            }
        }

        private static final class OfDouble
        extends EmptySpliterator<Double, Spliterator.OfDouble, DoubleConsumer>
        implements Spliterator.OfDouble {
            OfDouble() {
            }
        }

        private static final class OfRef<T>
        extends EmptySpliterator<T, Spliterator<T>, Consumer<? super T>>
        implements Spliterator<T> {
            OfRef() {
            }
        }
    }

    public static abstract class AbstractLongSpliterator
    extends BaseSpliterator<Long, Spliterator.OfLong>
    implements Spliterator.OfLong {
        protected AbstractLongSpliterator(long size, int characteristics) {
            super(size, characteristics);
        }
    }

    public static abstract class AbstractIntSpliterator
    extends BaseSpliterator<Integer, Spliterator.OfInt>
    implements Spliterator.OfInt {
        protected AbstractIntSpliterator(long size, int characteristics) {
            super(size, characteristics);
        }
    }

    public static abstract class AbstractDoubleSpliterator
    extends BaseSpliterator<Double, Spliterator.OfDouble>
    implements Spliterator.OfDouble {
        protected AbstractDoubleSpliterator(long size, int characteristics) {
            super(size, characteristics);
        }
    }

    public static abstract class AbstractSpliterator<T>
    extends BaseSpliterator<T, Spliterator<T>>
    implements Spliterator<T> {
        protected AbstractSpliterator(long size, int characteristics) {
            super(size, characteristics);
        }
    }

    private static abstract class BaseSpliterator<T, S extends Spliterator<T>>
    implements Spliterator<T> {
        private final int characteristics;
        private long sizeEstimate;

        BaseSpliterator(long size, int characteristics) {
            this.sizeEstimate = size;
            this.characteristics = (characteristics & 0x40) != 0 ? characteristics | 0x4000 : characteristics;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public long estimateSize() {
            return this.sizeEstimate;
        }

        public S trySplit() {
            return null;
        }
    }
}

