/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javaemul.internal.InternalPreconditions;
import jsinterop.annotations.JsNonNull;

public class Vector<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private ArrayList<E> arrayList;
    private E exposeElement;

    public Vector() {
        this.arrayList = new ArrayList();
    }

    public Vector(Collection<? extends E> c) {
        this.arrayList = new ArrayList();
        this.addAll(c);
    }

    public Vector(int initialCapacity) {
        this.arrayList = new ArrayList(initialCapacity);
    }

    public Vector(int initialCapacity, int ignoredCapacityIncrement) {
        this(initialCapacity);
    }

    @Override
    public boolean add(E o) {
        return this.arrayList.add(o);
    }

    @Override
    public void add(int index, E o) {
        Vector.checkArrayElementIndex(index, this.size() + 1);
        this.arrayList.add(index, o);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.arrayList.addAll((Collection)c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Vector.checkArrayElementIndex(index, this.size() + 1);
        return this.arrayList.addAll(index, c);
    }

    public void addElement(E o) {
        this.add(o);
    }

    public int capacity() {
        return this.arrayList.size();
    }

    @Override
    public void clear() {
        this.arrayList.clear();
    }

    public Object clone() {
        return new Vector<E>(this);
    }

    @Override
    public boolean contains(Object elem) {
        return this.arrayList.contains(elem);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.arrayList.containsAll(c);
    }

    public void copyInto(Object[] objs) {
        int i = -1;
        int n = this.size();
        while (++i < n) {
            objs[i] = this.get(i);
        }
    }

    public E elementAt(int index) {
        return this.get(index);
    }

    public Enumeration<E> elements() {
        return Collections.enumeration(this.arrayList);
    }

    public void ensureCapacity(int capacity) {
        this.arrayList.ensureCapacity(capacity);
    }

    public E firstElement() {
        InternalPreconditions.checkElement(!this.isEmpty());
        return this.get(0);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        this.arrayList.forEach((Consumer)consumer);
    }

    @Override
    public E get(int index) {
        Vector.checkArrayElementIndex(index, this.size());
        return (E)this.arrayList.get(index);
    }

    @Override
    public int indexOf(Object elem) {
        return this.arrayList.indexOf(elem);
    }

    public int indexOf(Object elem, int index) {
        Vector.checkArrayIndexOutOfBounds(index >= 0, index);
        return this.arrayList.indexOf(elem, index);
    }

    public void insertElementAt(E o, int index) {
        this.add(index, o);
    }

    @Override
    public boolean isEmpty() {
        return this.arrayList.size() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return this.arrayList.iterator();
    }

    public E lastElement() {
        InternalPreconditions.checkElement(!this.isEmpty());
        return this.get(this.size() - 1);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.arrayList.lastIndexOf(o);
    }

    public int lastIndexOf(Object o, int index) {
        Vector.checkArrayIndexOutOfBounds(index < this.size(), index);
        return this.arrayList.lastIndexOf(o, index);
    }

    @Override
    public E remove(int index) {
        Vector.checkArrayElementIndex(index, this.size());
        return (E)this.arrayList.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.arrayList.removeAll(c);
    }

    public void removeAllElements() {
        this.clear();
    }

    public boolean removeElement(Object o) {
        return this.remove(o);
    }

    public void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.arrayList.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        this.arrayList.replaceAll((UnaryOperator)operator);
    }

    @Override
    public E set(int index, E elem) {
        Vector.checkArrayElementIndex(index, this.size());
        return (E)this.arrayList.set(index, (Object)elem);
    }

    public void setElementAt(E o, int index) {
        this.set(index, o);
    }

    public void setSize(int size) {
        Vector.checkArrayIndexOutOfBounds(size >= 0, size);
        this.arrayList.setSize(size);
    }

    @Override
    public int size() {
        return this.arrayList.size();
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.arrayList.sort(c);
    }

    @Override
    public @JsNonNull List<E> subList(int fromIndex, int toIndex) {
        return this.arrayList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.arrayList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.arrayList.toArray((Object[])a);
    }

    @Override
    public String toString() {
        return this.arrayList.toString();
    }

    public void trimToSize() {
        this.arrayList.trimToSize();
    }

    @Override
    protected void removeRange(int fromIndex, int endIndex) {
        this.arrayList.removeRange(fromIndex, endIndex);
    }

    private static void checkArrayElementIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static void checkArrayIndexOutOfBounds(boolean expression, int index) {
        if (!expression) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index));
        }
    }
}

