/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javaemul.internal.InternalPreconditions;

public class ConcurrentHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V> {
    private final Map<K, V> backingMap;

    public ConcurrentHashMap() {
        this.backingMap = new HashMap();
    }

    public ConcurrentHashMap(int initialCapacity) {
        this.backingMap = new HashMap(initialCapacity);
    }

    public ConcurrentHashMap(int initialCapacity, float loadFactor) {
        this.backingMap = new HashMap(initialCapacity, loadFactor);
    }

    public ConcurrentHashMap(Map<? extends K, ? extends V> t) {
        this.backingMap = new HashMap<K, V>(t);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        InternalPreconditions.checkNotNull(key);
        InternalPreconditions.checkNotNull(value);
        return this.backingMap.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object oldValue) {
        V mapValue = this.get(key);
        if (mapValue != null && mapValue.equals(oldValue)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        InternalPreconditions.checkNotNull(oldValue);
        InternalPreconditions.checkNotNull(newValue);
        V mapValue = this.get(key);
        if (oldValue.equals(mapValue)) {
            this.put(key, newValue);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        InternalPreconditions.checkNotNull(value);
        if (this.containsKey(key)) {
            return this.put(key, value);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        InternalPreconditions.checkNotNull(key);
        return this.backingMap.containsKey(key);
    }

    @Override
    public V get(Object key) {
        InternalPreconditions.checkNotNull(key);
        return this.backingMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        InternalPreconditions.checkNotNull(key);
        InternalPreconditions.checkNotNull(value);
        return this.backingMap.put(key, value);
    }

    @Override
    public boolean containsValue(Object value) {
        InternalPreconditions.checkNotNull(value);
        return this.backingMap.containsValue(value);
    }

    @Override
    public V remove(Object key) {
        InternalPreconditions.checkNotNull(key);
        return this.backingMap.remove(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public Enumeration<V> elements() {
        return Collections.enumeration(this.values());
    }

    public Enumeration<K> keys() {
        return Collections.enumeration(this.keySet());
    }

    public static <T> Set<T> newKeySet() {
        return new HashSet();
    }
}

