/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

public enum TimeUnit {
    NANOSECONDS{

        @Override
        public long toNanos(long d) {
            return d;
        }

        @Override
        public long toMicros(long d) {
            return d / 1000L;
        }

        @Override
        public long toMillis(long d) {
            return d / 1000000L;
        }

        @Override
        public long toSeconds(long d) {
            return d / 1000000000L;
        }

        @Override
        public long toMinutes(long d) {
            return d / 60000000000L;
        }

        @Override
        public long toHours(long d) {
            return d / 3600000000000L;
        }

        @Override
        public long toDays(long d) {
            return d / 86400000000000L;
        }

        @Override
        public long convert(long d, TimeUnit u) {
            return u.toNanos(d);
        }
    }
    ,
    MICROSECONDS{

        @Override
        public long toNanos(long d) {
            return 2.x(d, 1000L, 9223372036854775L);
        }

        @Override
        public long toMicros(long d) {
            return d;
        }

        @Override
        public long toMillis(long d) {
            return d / 1000L;
        }

        @Override
        public long toSeconds(long d) {
            return d / 1000000L;
        }

        @Override
        public long toMinutes(long d) {
            return d / 60000000L;
        }

        @Override
        public long toHours(long d) {
            return d / 3600000000L;
        }

        @Override
        public long toDays(long d) {
            return d / 86400000000L;
        }

        @Override
        public long convert(long d, TimeUnit u) {
            return u.toMicros(d);
        }
    }
    ,
    MILLISECONDS{

        @Override
        public long toNanos(long d) {
            return 3.x(d, 1000000L, 9223372036854L);
        }

        @Override
        public long toMicros(long d) {
            return 3.x(d, 1000L, 9223372036854775L);
        }

        @Override
        public long toMillis(long d) {
            return d;
        }

        @Override
        public long toSeconds(long d) {
            return d / 1000L;
        }

        @Override
        public long toMinutes(long d) {
            return d / 60000L;
        }

        @Override
        public long toHours(long d) {
            return d / 3600000L;
        }

        @Override
        public long toDays(long d) {
            return d / 86400000L;
        }

        @Override
        public long convert(long d, TimeUnit u) {
            return u.toMillis(d);
        }
    }
    ,
    SECONDS{

        @Override
        public long toNanos(long d) {
            return 4.x(d, 1000000000L, 9223372036L);
        }

        @Override
        public long toMicros(long d) {
            return 4.x(d, 1000000L, 9223372036854L);
        }

        @Override
        public long toMillis(long d) {
            return 4.x(d, 1000L, 9223372036854775L);
        }

        @Override
        public long toSeconds(long d) {
            return d;
        }

        @Override
        public long toMinutes(long d) {
            return d / 60L;
        }

        @Override
        public long toHours(long d) {
            return d / 3600L;
        }

        @Override
        public long toDays(long d) {
            return d / 86400L;
        }

        @Override
        public long convert(long d, TimeUnit u) {
            return u.toSeconds(d);
        }
    }
    ,
    MINUTES{

        @Override
        public long toNanos(long d) {
            return 5.x(d, 60000000000L, 153722867L);
        }

        @Override
        public long toMicros(long d) {
            return 5.x(d, 60000000L, 153722867280L);
        }

        @Override
        public long toMillis(long d) {
            return 5.x(d, 60000L, 153722867280912L);
        }

        @Override
        public long toSeconds(long d) {
            return 5.x(d, 60L, 0x222222222222222L);
        }

        @Override
        public long toMinutes(long d) {
            return d;
        }

        @Override
        public long toHours(long d) {
            return d / 60L;
        }

        @Override
        public long toDays(long d) {
            return d / 1440L;
        }

        @Override
        public long convert(long d, TimeUnit u) {
            return u.toMinutes(d);
        }
    }
    ,
    HOURS{

        @Override
        public long toNanos(long d) {
            return 6.x(d, 3600000000000L, 2562047L);
        }

        @Override
        public long toMicros(long d) {
            return 6.x(d, 3600000000L, 2562047788L);
        }

        @Override
        public long toMillis(long d) {
            return 6.x(d, 3600000L, 2562047788015L);
        }

        @Override
        public long toSeconds(long d) {
            return 6.x(d, 3600L, 2562047788015215L);
        }

        @Override
        public long toMinutes(long d) {
            return 6.x(d, 60L, 0x222222222222222L);
        }

        @Override
        public long toHours(long d) {
            return d;
        }

        @Override
        public long toDays(long d) {
            return d / 24L;
        }

        @Override
        public long convert(long d, TimeUnit u) {
            return u.toHours(d);
        }
    }
    ,
    DAYS{

        @Override
        public long toNanos(long d) {
            return 7.x(d, 86400000000000L, 106751L);
        }

        @Override
        public long toMicros(long d) {
            return 7.x(d, 86400000000L, 106751991L);
        }

        @Override
        public long toMillis(long d) {
            return 7.x(d, 86400000L, 106751991167L);
        }

        @Override
        public long toSeconds(long d) {
            return 7.x(d, 86400L, 106751991167300L);
        }

        @Override
        public long toMinutes(long d) {
            return 7.x(d, 1440L, 0x16C16C16C16C16L);
        }

        @Override
        public long toHours(long d) {
            return 7.x(d, 24L, 0x555555555555555L);
        }

        @Override
        public long toDays(long d) {
            return d;
        }

        @Override
        public long convert(long d, TimeUnit u) {
            return u.toDays(d);
        }
    };

    private static final long C0 = 1L;
    private static final long C1 = 1000L;
    private static final long C2 = 1000000L;
    private static final long C3 = 1000000000L;
    private static final long C4 = 60000000000L;
    private static final long C5 = 3600000000000L;
    private static final long C6 = 86400000000000L;
    private static final long MAX = Long.MAX_VALUE;
    private static final long C6_C0 = 86400000000000L;
    private static final long C6_C1 = 86400000000L;
    private static final long C6_C2 = 86400000L;
    private static final long C6_C3 = 86400L;
    private static final long C6_C4 = 1440L;
    private static final long C6_C5 = 24L;
    private static final long C5_C0 = 3600000000000L;
    private static final long C5_C1 = 3600000000L;
    private static final long C5_C2 = 3600000L;
    private static final long C5_C3 = 3600L;
    private static final long C5_C4 = 60L;
    private static final long C4_C0 = 60000000000L;
    private static final long C4_C1 = 60000000L;
    private static final long C4_C2 = 60000L;
    private static final long C4_C3 = 60L;
    private static final long C3_C0 = 1000000000L;
    private static final long C3_C1 = 1000000L;
    private static final long C3_C2 = 1000L;
    private static final long C2_C0 = 1000000L;
    private static final long C2_C1 = 1000L;
    private static final long C1_C0 = 1000L;
    private static final long MAX_C6_C0 = 106751L;
    private static final long MAX_C6_C1 = 106751991L;
    private static final long MAX_C6_C2 = 106751991167L;
    private static final long MAX_C6_C3 = 106751991167300L;
    private static final long MAX_C6_C4 = 0x16C16C16C16C16L;
    private static final long MAX_C6_C5 = 0x555555555555555L;
    private static final long MAX_C5_C0 = 2562047L;
    private static final long MAX_C5_C1 = 2562047788L;
    private static final long MAX_C5_C2 = 2562047788015L;
    private static final long MAX_C5_C3 = 2562047788015215L;
    private static final long MAX_C5_C4 = 0x222222222222222L;
    private static final long MAX_C4_C0 = 153722867L;
    private static final long MAX_C4_C1 = 153722867280L;
    private static final long MAX_C4_C2 = 153722867280912L;
    private static final long MAX_C4_C3 = 0x222222222222222L;
    private static final long MAX_C3_C0 = 9223372036L;
    private static final long MAX_C3_C1 = 9223372036854L;
    private static final long MAX_C3_C2 = 9223372036854775L;
    private static final long MAX_C2_C0 = 9223372036854L;
    private static final long MAX_C2_C1 = 9223372036854775L;
    private static final long MAX_C1_C0 = 9223372036854775L;

    static long x(long d, long m, long over) {
        if (d > over) {
            return Long.MAX_VALUE;
        }
        if (d < -over) {
            return Long.MIN_VALUE;
        }
        return d * m;
    }

    public abstract long convert(long var1, TimeUnit var3);

    public abstract long toNanos(long var1);

    public abstract long toMicros(long var1);

    public abstract long toMillis(long var1);

    public abstract long toSeconds(long var1);

    public abstract long toMinutes(long var1);

    public abstract long toHours(long var1);

    public abstract long toDays(long var1);
}

