/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.Serializable;
import java.util.Locale;

public class Level
implements Serializable {
    public static Level ALL = new LevelAll();
    public static Level CONFIG = new LevelConfig();
    public static Level FINE = new LevelFine();
    public static Level FINER = new LevelFiner();
    public static Level FINEST = new LevelFinest();
    public static Level INFO = new LevelInfo();
    public static Level OFF = new LevelOff();
    public static Level SEVERE = new LevelSevere();
    public static Level WARNING = new LevelWarning();

    public static Level parse(String name) {
        String value;
        if (System.getProperty("jre.logging.logLevel") == "OFF") {
            return null;
        }
        switch (value = name.toUpperCase(Locale.ROOT)) {
            case "ALL": {
                return ALL;
            }
            case "CONFIG": {
                return CONFIG;
            }
            case "FINE": {
                return FINE;
            }
            case "FINER": {
                return FINER;
            }
            case "FINEST": {
                return FINEST;
            }
            case "INFO": {
                return INFO;
            }
            case "OFF": {
                return OFF;
            }
            case "SEVERE": {
                return SEVERE;
            }
            case "WARNING": {
                return WARNING;
            }
        }
        throw new IllegalArgumentException("Invalid level \"" + name + "\"");
    }

    protected Level() {
    }

    public String getName() {
        return "DUMMY";
    }

    public int intValue() {
        return -1;
    }

    public String toString() {
        return this.getName();
    }

    private static class LevelWarning
    extends Level {
        private LevelWarning() {
        }

        @Override
        public String getName() {
            return "WARNING";
        }

        @Override
        public int intValue() {
            return 900;
        }
    }

    private static class LevelSevere
    extends Level {
        private LevelSevere() {
        }

        @Override
        public String getName() {
            return "SEVERE";
        }

        @Override
        public int intValue() {
            return 1000;
        }
    }

    private static class LevelOff
    extends Level {
        private LevelOff() {
        }

        @Override
        public String getName() {
            return "OFF";
        }

        @Override
        public int intValue() {
            return Integer.MAX_VALUE;
        }
    }

    private static class LevelInfo
    extends Level {
        private LevelInfo() {
        }

        @Override
        public String getName() {
            return "INFO";
        }

        @Override
        public int intValue() {
            return 800;
        }
    }

    private static class LevelFinest
    extends Level {
        private LevelFinest() {
        }

        @Override
        public String getName() {
            return "FINEST";
        }

        @Override
        public int intValue() {
            return 300;
        }
    }

    private static class LevelFiner
    extends Level {
        private LevelFiner() {
        }

        @Override
        public String getName() {
            return "FINER";
        }

        @Override
        public int intValue() {
            return 400;
        }
    }

    private static class LevelFine
    extends Level {
        private LevelFine() {
        }

        @Override
        public String getName() {
            return "FINE";
        }

        @Override
        public int intValue() {
            return 500;
        }
    }

    private static class LevelConfig
    extends Level {
        private LevelConfig() {
        }

        @Override
        public String getName() {
            return "CONFIG";
        }

        @Override
        public int intValue() {
            return 700;
        }
    }

    private static class LevelAll
    extends Level {
        private LevelAll() {
        }

        @Override
        public String getName() {
            return "ALL";
        }

        @Override
        public int intValue() {
            return Integer.MIN_VALUE;
        }
    }
}

