/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javaemul.internal.annotations.HasNoSideEffects;

public class Logger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    private static final boolean LOGGING_OFF;
    private static final boolean ALL_ENABLED;
    private static final boolean INFO_ENABLED;
    private static final boolean WARNING_ENABLED;
    private static final boolean SEVERE_ENABLED;
    private static boolean handlersAdded;
    private List<Handler> handlers;
    private Level level;
    private String name;
    private Logger parent;
    private boolean useParentHandlers;

    public static Logger getGlobal() {
        return Logger.getLogger(GLOBAL_LOGGER_NAME);
    }

    @HasNoSideEffects
    public static Logger getLogger(String name) {
        if (LOGGING_OFF) {
            return new Logger(null, null);
        }
        return LogManager.getLogManager().ensureLogger(name);
    }

    protected Logger(String name, String resourceName) {
        if (LOGGING_OFF) {
            return;
        }
        this.name = name;
        this.useParentHandlers = true;
        this.handlers = new ArrayList<Handler>();
    }

    public void addHandler(Handler handler) {
        if (LOGGING_OFF) {
            return;
        }
        handlersAdded = true;
        this.handlers.add(handler);
    }

    public void config(String msg) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.CONFIG, msg);
    }

    public void config(Supplier<String> msgSupplier) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.CONFIG, msgSupplier);
    }

    public void fine(String msg) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.FINE, msg);
    }

    public void fine(Supplier<String> msgSupplier) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.FINE, msgSupplier);
    }

    public void finer(String msg) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.FINER, msg);
    }

    public void finer(Supplier<String> msgSupplier) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.FINER, msgSupplier);
    }

    public void finest(String msg) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.FINEST, msg);
    }

    public void finest(Supplier<String> msgSupplier) {
        if (!ALL_ENABLED) {
            return;
        }
        this.log(Level.FINEST, msgSupplier);
    }

    public void info(String msg) {
        if (!INFO_ENABLED) {
            return;
        }
        this.log(Level.INFO, msg);
    }

    public void info(Supplier<String> msgSupplier) {
        if (!INFO_ENABLED) {
            return;
        }
        this.log(Level.INFO, msgSupplier);
    }

    public void warning(String msg) {
        if (!WARNING_ENABLED) {
            return;
        }
        this.log(Level.WARNING, msg);
    }

    public void warning(Supplier<String> msgSupplier) {
        if (!WARNING_ENABLED) {
            return;
        }
        this.log(Level.WARNING, msgSupplier);
    }

    public void severe(String msg) {
        if (!SEVERE_ENABLED) {
            return;
        }
        this.log(Level.SEVERE, msg);
    }

    public void severe(Supplier<String> msgSupplier) {
        if (!SEVERE_ENABLED) {
            return;
        }
        this.log(Level.SEVERE, msgSupplier);
    }

    public Handler[] getHandlers() {
        if (LOGGING_OFF) {
            return new Handler[0];
        }
        return this.handlers.toArray(new Handler[this.handlers.size()]);
    }

    public Level getLevel() {
        return LOGGING_OFF ? null : this.level;
    }

    public String getName() {
        return LOGGING_OFF ? null : this.name;
    }

    public Logger getParent() {
        return LOGGING_OFF ? null : this.parent;
    }

    public boolean getUseParentHandlers() {
        return LOGGING_OFF ? false : this.useParentHandlers;
    }

    public boolean isLoggable(Level messageLevel) {
        if (!handlersAdded) {
            return false;
        }
        if (ALL_ENABLED) {
            return messageLevel.intValue() >= this.getEffectiveLevel().intValue();
        }
        if (INFO_ENABLED) {
            return messageLevel.intValue() >= Level.INFO.intValue();
        }
        if (WARNING_ENABLED) {
            return messageLevel.intValue() >= Level.WARNING.intValue();
        }
        if (SEVERE_ENABLED) {
            return messageLevel.intValue() >= Level.SEVERE.intValue();
        }
        return false;
    }

    public void log(Level level, String msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, Supplier<String> msgSupplier) {
        this.log(level, null, msgSupplier);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.actuallyLog(level, msg, thrown);
        }
    }

    public void log(Level level, Throwable thrown, Supplier<String> msgSupplier) {
        if (this.isLoggable(level)) {
            this.actuallyLog(level, msgSupplier.get(), thrown);
        }
    }

    public void log(LogRecord record) {
        if (this.isLoggable(record.getLevel())) {
            this.actuallyLog(record);
        }
    }

    public void removeHandler(Handler handler) {
        if (LOGGING_OFF) {
            return;
        }
        this.handlers.remove(handler);
    }

    public void setLevel(Level newLevel) {
        if (LOGGING_OFF) {
            return;
        }
        this.level = newLevel;
    }

    public void setParent(Logger newParent) {
        if (LOGGING_OFF) {
            return;
        }
        if (newParent != null) {
            this.parent = newParent;
        }
    }

    public void setUseParentHandlers(boolean newUseParentHandlers) {
        if (LOGGING_OFF) {
            return;
        }
        this.useParentHandlers = newUseParentHandlers;
    }

    private Level getEffectiveLevel() {
        if (this.level != null) {
            return this.level;
        }
        for (Logger logger = this.getParent(); logger != null; logger = logger.getParent()) {
            Level effectiveLevel = logger.getLevel();
            if (effectiveLevel == null) continue;
            return effectiveLevel;
        }
        return Level.INFO;
    }

    private void actuallyLog(Level level, String msg, Throwable thrown) {
        LogRecord record = new LogRecord(level, msg);
        record.setThrown(thrown);
        record.setLoggerName(this.getName());
        this.actuallyLog(record);
    }

    private void actuallyLog(LogRecord record) {
        Logger logger = this;
        while (logger != null) {
            for (Handler handler : logger.getHandlers()) {
                handler.publish(record);
            }
            logger = logger.getUseParentHandlers() ? logger.getParent() : null;
        }
    }

    static {
        String level = System.getProperty("jre.logging.logLevel");
        if (level != "ALL" && level != "INFO" && level != "WARNING" && level != "SEVERE" && level != "OFF") {
            throw new AssertionError((Object)("Undefined value for jre.logging.logLevel: '" + level + "'"));
        }
        LOGGING_OFF = level == "OFF";
        ALL_ENABLED = level == "ALL";
        INFO_ENABLED = level == "ALL" || level == "INFO";
        WARNING_ENABLED = level == "ALL" || level == "INFO" || level == "WARNING";
        SEVERE_ENABLED = level == "ALL" || level == "INFO" || level == "WARNING" || level == "SEVERE";
    }
}

