/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStreamImpl;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.PrimitiveLists;

public interface DoubleStream
extends BaseStream<Double, DoubleStream> {
    public static Builder builder() {
        return new Builder(){
            private PrimitiveLists.Double items = PrimitiveLists.createForDouble();

            @Override
            public void accept(double t) {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                this.items.push(t);
            }

            @Override
            public DoubleStream build() {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                DoubleStream stream = Arrays.stream(this.items.internalArray(), 0, this.items.size());
                this.items = null;
                return stream;
            }
        };
    }

    public static DoubleStream concat(DoubleStream a, DoubleStream b) {
        final Spliterator<DoubleStream> spliteratorOfStreams = Arrays.asList(a, b).spliterator();
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 0){
            Spliterator.OfDouble next;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        DoubleStreamImpl result = new DoubleStreamImpl(null, spliterator);
        return (DoubleStream)((DoubleStream)result.onClose(a::close)).onClose(b::close);
    }

    public static DoubleStream empty() {
        return new DoubleStreamImpl.Empty(null);
    }

    public static DoubleStream generate(final DoubleSupplier s) {
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1040){

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                action.accept(s.getAsDouble());
                return true;
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    public static DoubleStream iterate(double seed, DoubleUnaryOperator f) {
        return DoubleStream.iterate(seed, ignore -> true, f);
    }

    public static DoubleStream iterate(final double seed, final DoublePredicate hasNext, final DoubleUnaryOperator f) {
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 1040){
            private double next;
            private boolean isFirst;
            private boolean isTerminated;
            {
                super(size, characteristics);
                this.next = seed;
                this.isFirst = true;
                this.isTerminated = false;
            }

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (this.isTerminated) {
                    return false;
                }
                if (!this.isFirst) {
                    this.next = f.applyAsDouble(this.next);
                }
                this.isFirst = false;
                if (!hasNext.test(this.next)) {
                    this.isTerminated = true;
                    return false;
                }
                action.accept(this.next);
                return true;
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    public static DoubleStream of(double ... values) {
        return Arrays.stream(values);
    }

    public static DoubleStream of(double t) {
        return DoubleStream.of(new double[]{t});
    }

    public boolean allMatch(DoublePredicate var1);

    public boolean anyMatch(DoublePredicate var1);

    public OptionalDouble average();

    public Stream<Double> boxed();

    public <R> R collect(Supplier<R> var1, ObjDoubleConsumer<R> var2, BiConsumer<R, R> var3);

    public long count();

    public DoubleStream distinct();

    public DoubleStream filter(DoublePredicate var1);

    public OptionalDouble findAny();

    public OptionalDouble findFirst();

    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> var1);

    public void forEach(DoubleConsumer var1);

    public void forEachOrdered(DoubleConsumer var1);

    public PrimitiveIterator.OfDouble iterator();

    public DoubleStream limit(long var1);

    public DoubleStream map(DoubleUnaryOperator var1);

    public IntStream mapToInt(DoubleToIntFunction var1);

    public LongStream mapToLong(DoubleToLongFunction var1);

    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> var1);

    public OptionalDouble max();

    public OptionalDouble min();

    public boolean noneMatch(DoublePredicate var1);

    @Override
    public DoubleStream parallel();

    public DoubleStream peek(DoubleConsumer var1);

    public OptionalDouble reduce(DoubleBinaryOperator var1);

    public double reduce(double var1, DoubleBinaryOperator var3);

    @Override
    public DoubleStream sequential();

    public DoubleStream skip(long var1);

    public DoubleStream sorted();

    public Spliterator.OfDouble spliterator();

    public double sum();

    public DoubleSummaryStatistics summaryStatistics();

    default public DoubleStream dropWhile(final DoublePredicate predicate) {
        final Spliterator.OfDouble prev = this.spliterator();
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(prev.estimateSize(), prev.characteristics() & 0xFFFFBFBF){
            private boolean dropping;
            private boolean found;
            {
                super(size, characteristics);
                this.dropping = true;
            }

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (!this.dropping) {
                    return prev.tryAdvance(action);
                }
                this.found = false;
                while (this.dropping && prev.tryAdvance(item -> {
                    if (!predicate.test(item)) {
                        this.dropping = false;
                        this.found = true;
                        action.accept(item);
                    }
                })) {
                }
                return this.found;
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    default public DoubleStream takeWhile(final DoublePredicate predicate) {
        final Spliterator.OfDouble original = this.spliterator();
        Spliterators.AbstractDoubleSpliterator spliterator = new Spliterators.AbstractDoubleSpliterator(original.estimateSize(), original.characteristics() & 0xFFFFBFBF){
            private boolean taking;
            private boolean found;
            {
                super(size, characteristics);
                this.taking = true;
            }

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (!this.taking) {
                    return false;
                }
                this.found = false;
                original.tryAdvance(item -> {
                    if (predicate.test(item)) {
                        this.found = true;
                        action.accept(item);
                    } else {
                        this.taking = false;
                    }
                });
                return this.found;
            }
        };
        return StreamSupport.doubleStream(spliterator, false);
    }

    public double[] toArray();

    public static interface Builder
    extends DoubleConsumer {
        @Override
        public void accept(double var1);

        default public Builder add(double t) {
            this.accept(t);
            return this;
        }

        public DoubleStream build();
    }
}

