/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.HashSet;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.IntStreamImpl;
import java.util.stream.LongStream;
import java.util.stream.LongStreamImpl;
import java.util.stream.Stream;
import java.util.stream.StreamImpl;
import java.util.stream.TerminatableStream;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.PrimitiveLists;

final class DoubleStreamImpl
extends TerminatableStream<DoubleStreamImpl>
implements DoubleStream {
    private final Spliterator.OfDouble spliterator;

    public DoubleStreamImpl(TerminatableStream<?> previous, Spliterator.OfDouble spliterator) {
        super(previous);
        this.spliterator = spliterator;
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.forEachOrdered(action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.terminate();
        this.spliterator.forEachRemaining(action);
    }

    @Override
    public double[] toArray() {
        this.terminate();
        PrimitiveLists.Double entries = PrimitiveLists.createForDouble();
        this.spliterator.forEachRemaining(value -> entries.push(value));
        return entries.toArray();
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        this.terminate();
        ValueConsumer holder = new ValueConsumer();
        holder.value = identity;
        this.spliterator.forEachRemaining(value -> holder.accept(op.applyAsDouble(holder.value, value)));
        return holder.value;
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        ValueConsumer holder = new ValueConsumer();
        if (this.spliterator.tryAdvance(holder)) {
            return OptionalDouble.of(this.reduce(holder.value, op));
        }
        this.terminate();
        return OptionalDouble.empty();
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        this.terminate();
        Object acc = supplier.get();
        this.spliterator.forEachRemaining(value -> accumulator.accept(acc, value));
        return acc;
    }

    @Override
    public double sum() {
        return this.summaryStatistics().getSum();
    }

    @Override
    public OptionalDouble min() {
        DoubleSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(stats.getMin());
    }

    @Override
    public OptionalDouble max() {
        DoubleSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(stats.getMax());
    }

    @Override
    public long count() {
        this.terminate();
        long count = 0L;
        while (this.spliterator.tryAdvance(value -> {})) {
            ++count;
        }
        return count;
    }

    @Override
    public OptionalDouble average() {
        DoubleSummaryStatistics stats = this.summaryStatistics();
        if (stats.getCount() == 0L) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(stats.getAverage());
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.collect(DoubleSummaryStatistics::new, (doubleSummaryStatistics, value) -> doubleSummaryStatistics.accept(value), DoubleSummaryStatistics::combine);
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return this.filter(predicate).findFirst().isPresent();
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return !this.anyMatch(predicate.negate());
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        this.terminate();
        ValueConsumer holder = new ValueConsumer();
        if (this.spliterator.tryAdvance(holder)) {
            return OptionalDouble.of(holder.value);
        }
        return OptionalDouble.empty();
    }

    @Override
    public OptionalDouble findAny() {
        return this.findFirst();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        this.terminate();
        return this.spliterator;
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        this.throwIfTerminated();
        return new DoubleStreamImpl(this, new FilterSpliterator(predicate, this.spliterator));
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        this.throwIfTerminated();
        return new DoubleStreamImpl(this, new MapToDoubleSpliterator(mapper, this.spliterator));
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        this.throwIfTerminated();
        return new StreamImpl<U>(this, new MapToObjSpliterator<U>(mapper, this.spliterator));
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction mapper) {
        this.throwIfTerminated();
        return new IntStreamImpl(this, new MapToIntSpliterator(mapper, this.spliterator));
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction mapper) {
        this.throwIfTerminated();
        return new LongStreamImpl(this, new MapToLongSpliterator(mapper, this.spliterator));
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        this.throwIfTerminated();
        final MapToObjSpliterator<? extends DoubleStream> spliteratorOfStreams = new MapToObjSpliterator<DoubleStream>(mapper, this.spliterator);
        Spliterators.AbstractDoubleSpliterator flatMapSpliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 0){
            DoubleStream nextStream;
            Spliterator.OfDouble next;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.nextStream.close();
                    this.nextStream = null;
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.nextStream = n;
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        return new DoubleStreamImpl(this, flatMapSpliterator);
    }

    @Override
    public DoubleStream distinct() {
        this.throwIfTerminated();
        HashSet seen = new HashSet();
        return this.filter(seen::add);
    }

    @Override
    public DoubleStream sorted() {
        this.throwIfTerminated();
        Spliterators.AbstractDoubleSpliterator sortingSpliterator = new Spliterators.AbstractDoubleSpliterator(this.spliterator.estimateSize(), this.spliterator.characteristics() | 4){
            Spliterator.OfDouble ordered;
            {
                this.ordered = null;
            }

            @Override
            public Comparator<? super Double> getComparator() {
                return null;
            }

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                if (this.ordered == null) {
                    PrimitiveLists.Double list = PrimitiveLists.createForDouble();
                    DoubleStreamImpl.this.spliterator.forEachRemaining(value -> list.push(value));
                    Arrays.sort(list.internalArray(), 0, list.size());
                    this.ordered = Spliterators.spliterator(list.internalArray(), 0, list.size(), this.characteristics());
                }
                return this.ordered.tryAdvance(action);
            }
        };
        return new DoubleStreamImpl(this, sortingSpliterator);
    }

    @Override
    public DoubleStream peek(final DoubleConsumer action) {
        InternalPreconditions.checkNotNull(action);
        this.throwIfTerminated();
        Spliterators.AbstractDoubleSpliterator peekSpliterator = new Spliterators.AbstractDoubleSpliterator(this.spliterator.estimateSize(), this.spliterator.characteristics()){

            @Override
            public boolean tryAdvance(DoubleConsumer innerAction) {
                return DoubleStreamImpl.this.spliterator.tryAdvance(action.andThen(innerAction));
            }
        };
        return new DoubleStreamImpl(this, peekSpliterator);
    }

    @Override
    public DoubleStream limit(long maxSize) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
        return new DoubleStreamImpl(this, new LimitSpliterator(maxSize, this.spliterator));
    }

    @Override
    public DoubleStream skip(long n) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(n >= 0L, "n may not be negative");
        if (n == 0L) {
            return this;
        }
        return new DoubleStreamImpl(this, new SkipSpliterator(n, this.spliterator));
    }

    @Override
    public Stream<Double> boxed() {
        return this.mapToObj(Double::valueOf);
    }

    @Override
    public DoubleStream sequential() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public DoubleStream parallel() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public boolean isParallel() {
        this.throwIfTerminated();
        return false;
    }

    @Override
    public DoubleStream unordered() {
        this.throwIfTerminated();
        return this;
    }

    private static class ValueConsumer
    implements DoubleConsumer {
        double value;

        private ValueConsumer() {
        }

        @Override
        public void accept(double value) {
            this.value = value;
        }
    }

    private static final class LimitSpliterator
    extends Spliterators.AbstractDoubleSpliterator {
        private final long limit;
        private final Spliterator.OfDouble original;
        private int position = 0;

        public LimitSpliterator(long limit, Spliterator.OfDouble original) {
            super(original.hasCharacteristics(64) ? Math.min(original.estimateSize(), limit) : Long.MAX_VALUE, original.characteristics());
            this.limit = limit;
            this.original = original;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if ((long)this.position >= this.limit) {
                return false;
            }
            boolean result = this.original.tryAdvance(action);
            ++this.position;
            return result;
        }
    }

    private static final class SkipSpliterator
    extends Spliterators.AbstractDoubleSpliterator {
        private long skip;
        private final Spliterator.OfDouble original;

        public SkipSpliterator(long skip, Spliterator.OfDouble original) {
            super(original.hasCharacteristics(64) ? Math.max(0L, original.estimateSize() - skip) : Long.MAX_VALUE, original.characteristics());
            this.skip = skip;
            this.original = original;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            while (this.skip > 0L) {
                if (!this.original.tryAdvance(ignore -> {})) {
                    return false;
                }
                --this.skip;
            }
            return this.original.tryAdvance(action);
        }
    }

    private static final class FilterSpliterator
    extends Spliterators.AbstractDoubleSpliterator {
        private final DoublePredicate filter;
        private final Spliterator.OfDouble original;
        private boolean found;

        public FilterSpliterator(DoublePredicate filter, Spliterator.OfDouble original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFBFBF);
            InternalPreconditions.checkNotNull(filter);
            this.filter = filter;
            this.original = original;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            this.found = false;
            while (!this.found && this.original.tryAdvance(item -> {
                if (this.filter.test(item)) {
                    this.found = true;
                    action.accept(item);
                }
            })) {
            }
            return this.found;
        }
    }

    private static final class MapToDoubleSpliterator
    extends Spliterators.AbstractDoubleSpliterator {
        private final DoubleUnaryOperator map;
        private final Spliterator.OfDouble original;

        public MapToDoubleSpliterator(DoubleUnaryOperator map, Spliterator.OfDouble original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsDouble(u)));
        }
    }

    private static final class MapToLongSpliterator
    extends Spliterators.AbstractLongSpliterator {
        private final DoubleToLongFunction map;
        private final Spliterator.OfDouble original;

        public MapToLongSpliterator(DoubleToLongFunction map, Spliterator.OfDouble original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsLong(u)));
        }
    }

    private static final class MapToObjSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final DoubleFunction<? extends T> map;
        private final Spliterator.OfDouble original;

        public MapToObjSpliterator(DoubleFunction<? extends T> map, Spliterator.OfDouble original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.original.tryAdvance(u -> action.accept((T)this.map.apply(u)));
        }
    }

    private static final class MapToIntSpliterator
    extends Spliterators.AbstractIntSpliterator {
        private final DoubleToIntFunction map;
        private final Spliterator.OfDouble original;

        public MapToIntSpliterator(DoubleToIntFunction map, Spliterator.OfDouble original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            return this.original.tryAdvance(u -> action.accept(this.map.applyAsInt(u)));
        }
    }

    static class Empty
    extends TerminatableStream<Empty>
    implements DoubleStream {
        public Empty(TerminatableStream<?> previous) {
            super(previous);
        }

        @Override
        public DoubleStream filter(DoublePredicate predicate) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public DoubleStream map(DoubleUnaryOperator mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
            this.throwIfTerminated();
            return new StreamImpl.Empty(this);
        }

        @Override
        public IntStream mapToInt(DoubleToIntFunction mapper) {
            this.throwIfTerminated();
            return new IntStreamImpl.Empty(this);
        }

        @Override
        public LongStream mapToLong(DoubleToLongFunction mapper) {
            this.throwIfTerminated();
            return new LongStreamImpl.Empty(this);
        }

        @Override
        public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public DoubleStream distinct() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public DoubleStream sorted() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public DoubleStream peek(DoubleConsumer action) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public DoubleStream limit(long maxSize) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
            return this;
        }

        @Override
        public DoubleStream skip(long n) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(n >= 0L, "n may not be negative");
            return this;
        }

        @Override
        public void forEach(DoubleConsumer action) {
            this.terminate();
        }

        @Override
        public void forEachOrdered(DoubleConsumer action) {
            this.terminate();
        }

        @Override
        public double[] toArray() {
            this.terminate();
            return new double[0];
        }

        @Override
        public double reduce(double identity, DoubleBinaryOperator op) {
            this.terminate();
            return identity;
        }

        @Override
        public OptionalDouble reduce(DoubleBinaryOperator op) {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
            this.terminate();
            return supplier.get();
        }

        @Override
        public double sum() {
            this.terminate();
            return 0.0;
        }

        @Override
        public OptionalDouble min() {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public OptionalDouble max() {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public long count() {
            this.terminate();
            return 0L;
        }

        @Override
        public OptionalDouble average() {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public DoubleSummaryStatistics summaryStatistics() {
            this.terminate();
            return new DoubleSummaryStatistics();
        }

        @Override
        public boolean anyMatch(DoublePredicate predicate) {
            this.terminate();
            return false;
        }

        @Override
        public boolean allMatch(DoublePredicate predicate) {
            this.terminate();
            return true;
        }

        @Override
        public boolean noneMatch(DoublePredicate predicate) {
            this.terminate();
            return true;
        }

        @Override
        public OptionalDouble findFirst() {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public OptionalDouble findAny() {
            this.terminate();
            return OptionalDouble.empty();
        }

        @Override
        public Stream<Double> boxed() {
            this.throwIfTerminated();
            return new StreamImpl.Empty<Double>(this);
        }

        @Override
        public DoubleStream sequential() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public DoubleStream parallel() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public PrimitiveIterator.OfDouble iterator() {
            return Spliterators.iterator(this.spliterator());
        }

        @Override
        public Spliterator.OfDouble spliterator() {
            this.terminate();
            return Spliterators.emptyDoubleSpliterator();
        }

        @Override
        public boolean isParallel() {
            this.throwIfTerminated();
            return false;
        }

        @Override
        public DoubleStream unordered() {
            this.throwIfTerminated();
            return this;
        }
    }
}

