/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStreamImpl;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.PrimitiveLists;

public interface IntStream
extends BaseStream<Integer, IntStream> {
    public static Builder builder() {
        return new Builder(){
            private PrimitiveLists.Int items = PrimitiveLists.createForInt();

            @Override
            public void accept(int t) {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                this.items.push(t);
            }

            @Override
            public IntStream build() {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                IntStream stream = Arrays.stream(this.items.internalArray(), 0, this.items.size());
                this.items = null;
                return stream;
            }
        };
    }

    public static IntStream concat(IntStream a, IntStream b) {
        final Spliterator<IntStream> spliteratorOfStreams = Arrays.asList(a, b).spliterator();
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 0){
            Spliterator.OfInt next;

            @Override
            public boolean tryAdvance(IntConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        IntStreamImpl result = new IntStreamImpl(null, spliterator);
        return (IntStream)((IntStream)result.onClose(a::close)).onClose(b::close);
    }

    public static IntStream empty() {
        return new IntStreamImpl.Empty(null);
    }

    public static IntStream generate(final IntSupplier s) {
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 1040){

            @Override
            public boolean tryAdvance(IntConsumer action) {
                action.accept(s.getAsInt());
                return true;
            }
        };
        return StreamSupport.intStream(spliterator, false);
    }

    public static IntStream iterate(int seed, IntUnaryOperator f) {
        return IntStream.iterate(seed, ignore -> true, f);
    }

    public static IntStream iterate(final int seed, final IntPredicate hasNext, final IntUnaryOperator f) {
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 1040){
            private int next;
            private boolean isFirst;
            private boolean isTerminated;
            {
                super(size, characteristics);
                this.next = seed;
                this.isFirst = true;
                this.isTerminated = false;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (this.isTerminated) {
                    return false;
                }
                if (!this.isFirst) {
                    this.next = f.applyAsInt(this.next);
                }
                this.isFirst = false;
                if (!hasNext.test(this.next)) {
                    this.isTerminated = true;
                    return false;
                }
                action.accept(this.next);
                return true;
            }
        };
        return StreamSupport.intStream(spliterator, false);
    }

    public static IntStream of(int ... values) {
        return Arrays.stream(values);
    }

    public static IntStream of(int t) {
        return IntStream.of(new int[]{t});
    }

    public static IntStream range(int startInclusive, int endExclusive) {
        if (startInclusive >= endExclusive) {
            return IntStream.empty();
        }
        return IntStream.rangeClosed(startInclusive, endExclusive - 1);
    }

    public static IntStream rangeClosed(final int startInclusive, final int endInclusive) {
        if (startInclusive > endInclusive) {
            return IntStream.empty();
        }
        int count = endInclusive - startInclusive + 1;
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(count, 17493){
            private int next;
            {
                super(size, characteristics);
                this.next = startInclusive;
            }

            @Override
            public Comparator<? super Integer> getComparator() {
                return null;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (this.next <= endInclusive) {
                    action.accept(this.next++);
                    return true;
                }
                return false;
            }
        };
        return StreamSupport.intStream(spliterator, false);
    }

    public boolean allMatch(IntPredicate var1);

    public boolean anyMatch(IntPredicate var1);

    public DoubleStream asDoubleStream();

    public LongStream asLongStream();

    public OptionalDouble average();

    public Stream<Integer> boxed();

    public <R> R collect(Supplier<R> var1, ObjIntConsumer<R> var2, BiConsumer<R, R> var3);

    public long count();

    public IntStream distinct();

    public IntStream filter(IntPredicate var1);

    public OptionalInt findAny();

    public OptionalInt findFirst();

    public IntStream flatMap(IntFunction<? extends IntStream> var1);

    public void forEach(IntConsumer var1);

    public void forEachOrdered(IntConsumer var1);

    public PrimitiveIterator.OfInt iterator();

    public IntStream limit(long var1);

    public IntStream map(IntUnaryOperator var1);

    public DoubleStream mapToDouble(IntToDoubleFunction var1);

    public LongStream mapToLong(IntToLongFunction var1);

    public <U> Stream<U> mapToObj(IntFunction<? extends U> var1);

    public OptionalInt max();

    public OptionalInt min();

    public boolean noneMatch(IntPredicate var1);

    @Override
    public IntStream parallel();

    public IntStream peek(IntConsumer var1);

    public OptionalInt reduce(IntBinaryOperator var1);

    public int reduce(int var1, IntBinaryOperator var2);

    @Override
    public IntStream sequential();

    public IntStream skip(long var1);

    public IntStream sorted();

    public Spliterator.OfInt spliterator();

    public int sum();

    public IntSummaryStatistics summaryStatistics();

    default public IntStream dropWhile(final IntPredicate predicate) {
        final Spliterator.OfInt prev = this.spliterator();
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(prev.estimateSize(), prev.characteristics() & 0xFFFFBFBF){
            private boolean dropping;
            private boolean found;
            {
                super(size, characteristics);
                this.dropping = true;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (!this.dropping) {
                    return prev.tryAdvance(action);
                }
                this.found = false;
                while (this.dropping && prev.tryAdvance(item -> {
                    if (!predicate.test(item)) {
                        this.dropping = false;
                        this.found = true;
                        action.accept(item);
                    }
                })) {
                }
                return this.found;
            }
        };
        return StreamSupport.intStream(spliterator, false);
    }

    default public IntStream takeWhile(final IntPredicate predicate) {
        final Spliterator.OfInt original = this.spliterator();
        Spliterators.AbstractIntSpliterator spliterator = new Spliterators.AbstractIntSpliterator(original.estimateSize(), original.characteristics() & 0xFFFFBFBF){
            private boolean taking;
            private boolean found;
            {
                super(size, characteristics);
                this.taking = true;
            }

            @Override
            public boolean tryAdvance(IntConsumer action) {
                if (!this.taking) {
                    return false;
                }
                this.found = false;
                original.tryAdvance(item -> {
                    if (predicate.test(item)) {
                        this.found = true;
                        action.accept(item);
                    } else {
                        this.taking = false;
                    }
                });
                return this.found;
            }
        };
        return StreamSupport.intStream(spliterator, false);
    }

    public int[] toArray();

    public static interface Builder
    extends IntConsumer {
        @Override
        public void accept(int var1);

        default public Builder add(int t) {
            this.accept(t);
            return this;
        }

        public IntStream build();
    }
}

