/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStreamImpl;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javaemul.internal.InternalPreconditions;
import javaemul.internal.PrimitiveLists;

public interface LongStream
extends BaseStream<Long, LongStream> {
    public static Builder builder() {
        return new Builder(){
            private PrimitiveLists.Long items = new PrimitiveLists.Long();

            @Override
            public void accept(long t) {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                this.items.push(t);
            }

            @Override
            public LongStream build() {
                InternalPreconditions.checkState(this.items != null, "Builder already built");
                LongStream stream = Arrays.stream(this.items.internalArray(), 0, this.items.size());
                this.items = null;
                return stream;
            }
        };
    }

    public static LongStream concat(LongStream a, LongStream b) {
        final Spliterator<LongStream> spliteratorOfStreams = Arrays.asList(a, b).spliterator();
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 0){
            Spliterator.OfLong next;

            @Override
            public boolean tryAdvance(LongConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        LongStreamImpl result = new LongStreamImpl(null, spliterator);
        return (LongStream)((LongStream)result.onClose(a::close)).onClose(b::close);
    }

    public static LongStream empty() {
        return new LongStreamImpl.Empty(null);
    }

    public static LongStream generate(final LongSupplier s) {
        Spliterators.AbstractLongSpliterator spltierator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 1040){

            @Override
            public boolean tryAdvance(LongConsumer action) {
                action.accept(s.getAsLong());
                return true;
            }
        };
        return StreamSupport.longStream(spltierator, false);
    }

    public static LongStream iterate(long seed, LongUnaryOperator f) {
        return LongStream.iterate(seed, ignore -> true, f);
    }

    public static LongStream iterate(final long seed, final LongPredicate hasNext, final LongUnaryOperator f) {
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 1040){
            private long next;
            private boolean isFirst;
            private boolean isTerminated;
            {
                super(size, characteristics);
                this.next = seed;
                this.isFirst = true;
                this.isTerminated = false;
            }

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (this.isTerminated) {
                    return false;
                }
                if (!this.isFirst) {
                    this.next = f.applyAsLong(this.next);
                }
                this.isFirst = false;
                if (!hasNext.test(this.next)) {
                    this.isTerminated = true;
                    return false;
                }
                action.accept(this.next);
                return true;
            }
        };
        return StreamSupport.longStream(spliterator, false);
    }

    public static LongStream of(long ... values) {
        return Arrays.stream(values);
    }

    public static LongStream of(long t) {
        return LongStream.of(new long[]{t});
    }

    public static LongStream range(long startInclusive, long endExclusive) {
        if (startInclusive >= endExclusive) {
            return LongStream.empty();
        }
        return LongStream.rangeClosed(startInclusive, endExclusive - 1L);
    }

    public static LongStream rangeClosed(final long startInclusive, final long endInclusive) {
        if (startInclusive > endInclusive) {
            return LongStream.empty();
        }
        long count = endInclusive - startInclusive + 1L;
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(count, 17493){
            private long next;
            {
                super(size, characteristics);
                this.next = startInclusive;
            }

            @Override
            public Comparator<? super Long> getComparator() {
                return null;
            }

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (this.next <= endInclusive) {
                    action.accept(this.next++);
                    return true;
                }
                return false;
            }
        };
        return StreamSupport.longStream(spliterator, false);
    }

    public boolean allMatch(LongPredicate var1);

    public boolean anyMatch(LongPredicate var1);

    public DoubleStream asDoubleStream();

    public OptionalDouble average();

    public Stream<Long> boxed();

    public <R> R collect(Supplier<R> var1, ObjLongConsumer<R> var2, BiConsumer<R, R> var3);

    public long count();

    public LongStream distinct();

    public LongStream filter(LongPredicate var1);

    public OptionalLong findAny();

    public OptionalLong findFirst();

    public LongStream flatMap(LongFunction<? extends LongStream> var1);

    public void forEach(LongConsumer var1);

    public void forEachOrdered(LongConsumer var1);

    public PrimitiveIterator.OfLong iterator();

    public LongStream limit(long var1);

    public LongStream map(LongUnaryOperator var1);

    public DoubleStream mapToDouble(LongToDoubleFunction var1);

    public IntStream mapToInt(LongToIntFunction var1);

    public <U> Stream<U> mapToObj(LongFunction<? extends U> var1);

    public OptionalLong max();

    public OptionalLong min();

    public boolean noneMatch(LongPredicate var1);

    @Override
    public LongStream parallel();

    public LongStream peek(LongConsumer var1);

    public OptionalLong reduce(LongBinaryOperator var1);

    public long reduce(long var1, LongBinaryOperator var3);

    @Override
    public LongStream sequential();

    public LongStream skip(long var1);

    public LongStream sorted();

    public Spliterator.OfLong spliterator();

    public long sum();

    public LongSummaryStatistics summaryStatistics();

    default public LongStream dropWhile(final LongPredicate predicate) {
        final Spliterator.OfLong prev = this.spliterator();
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(prev.estimateSize(), prev.characteristics() & 0xFFFFBFBF){
            private boolean dropping;
            private boolean found;
            {
                super(size, characteristics);
                this.dropping = true;
            }

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (!this.dropping) {
                    return prev.tryAdvance(action);
                }
                this.found = false;
                while (this.dropping && prev.tryAdvance(item -> {
                    if (!predicate.test(item)) {
                        this.dropping = false;
                        this.found = true;
                        action.accept(item);
                    }
                })) {
                }
                return this.found;
            }
        };
        return StreamSupport.longStream(spliterator, false);
    }

    default public LongStream takeWhile(final LongPredicate predicate) {
        final Spliterator.OfLong original = this.spliterator();
        Spliterators.AbstractLongSpliterator spliterator = new Spliterators.AbstractLongSpliterator(original.estimateSize(), original.characteristics() & 0xFFFFBFBF){
            private boolean taking;
            private boolean found;
            {
                super(size, characteristics);
                this.taking = true;
            }

            @Override
            public boolean tryAdvance(LongConsumer action) {
                if (!this.taking) {
                    return false;
                }
                this.found = false;
                original.tryAdvance(item -> {
                    if (predicate.test(item)) {
                        this.found = true;
                        action.accept(item);
                    } else {
                        this.taking = false;
                    }
                });
                return this.found;
            }
        };
        return StreamSupport.longStream(spliterator, false);
    }

    public long[] toArray();

    public static interface Builder
    extends LongConsumer {
        @Override
        public void accept(long var1);

        default public Builder add(long t) {
            this.accept(t);
            return this;
        }

        public LongStream build();
    }
}

