/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.DoubleStreamImpl;
import java.util.stream.IntStream;
import java.util.stream.IntStreamImpl;
import java.util.stream.LongStream;
import java.util.stream.LongStreamImpl;
import java.util.stream.Stream;
import java.util.stream.TerminatableStream;
import javaemul.internal.InternalPreconditions;

final class StreamImpl<T>
extends TerminatableStream<StreamImpl<T>>
implements Stream<T> {
    private final Spliterator<T> spliterator;
    private static final Consumer<Object> NULL_CONSUMER = value -> {};

    public StreamImpl(TerminatableStream<?> prev, Spliterator<T> spliterator) {
        super(prev);
        this.spliterator = spliterator;
    }

    @Override
    public Spliterator<T> spliterator() {
        this.terminate();
        return this.spliterator;
    }

    @Override
    public Iterator<T> iterator() {
        return Spliterators.iterator(this.spliterator());
    }

    @Override
    public long count() {
        this.terminate();
        long count = 0L;
        while (this.spliterator.tryAdvance(a -> {})) {
            ++count;
        }
        return count;
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.forEachOrdered(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.terminate();
        this.spliterator.forEachRemaining(action);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(Object[]::new);
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        List<A> collected = this.collect(Collectors.toList());
        return collected.toArray(generator.apply(collected.size()));
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.collect(Collector.of(supplier, accumulator, (a, b) -> {
            combiner.accept(a, b);
            return a;
        }, new Collector.Characteristics[0]));
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return collector.finisher().apply(this.reduce(collector.supplier().get(), (a, t) -> {
            collector.accumulator().accept(a, t);
            return a;
        }, collector.combiner()));
    }

    @Override
    public Optional<T> findFirst() {
        this.terminate();
        ValueConsumer holder = new ValueConsumer();
        if (this.spliterator.tryAdvance(holder)) {
            return Optional.of(holder.value);
        }
        return Optional.empty();
    }

    @Override
    public Optional<T> findAny() {
        return this.findFirst();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.filter(predicate).spliterator().tryAdvance(NULL_CONSUMER);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return !this.anyMatch(predicate.negate());
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return !this.anyMatch(predicate);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.minBy(comparator));
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.reduce(BinaryOperator.maxBy(comparator));
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.reduce(identity, accumulator, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        ValueConsumer consumer = new ValueConsumer();
        if (!this.spliterator.tryAdvance(consumer)) {
            this.terminate();
            return Optional.empty();
        }
        return Optional.of(this.reduce(consumer.value, accumulator));
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        this.terminate();
        ValueConsumer consumer = new ValueConsumer();
        consumer.value = identity;
        this.spliterator.forEachRemaining(item -> consumer.accept(accumulator.apply((Object)consumer.value, (Object)item)));
        return (U)consumer.value;
    }

    @Override
    public Stream<T> filter(Predicate<? super T> predicate) {
        this.throwIfTerminated();
        return new StreamImpl<T>(this, new FilterSpliterator<T>(predicate, this.spliterator));
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
        this.throwIfTerminated();
        return new StreamImpl<T>(this, new MapToObjSpliterator<T, R>(mapper, this.spliterator));
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        this.throwIfTerminated();
        return new IntStreamImpl(this, new MapToIntSpliterator<T>(mapper, this.spliterator));
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        this.throwIfTerminated();
        return new LongStreamImpl(this, new MapToLongSpliterator<T>(mapper, this.spliterator));
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        this.throwIfTerminated();
        return new DoubleStreamImpl(this, new MapToDoubleSpliterator<T>(mapper, this.spliterator));
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        this.throwIfTerminated();
        final MapToObjSpliterator<? super T, ? extends Stream<? extends R>> spliteratorOfStreams = new MapToObjSpliterator<T, Stream<? extends R>>(mapper, this.spliterator);
        Spliterators.AbstractSpliterator flatMapSpliterator = new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 0){
            Stream<? extends R> nextStream;
            Spliterator<? extends R> next;

            @Override
            public boolean tryAdvance(Consumer<? super R> action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.nextStream.close();
                    this.nextStream = null;
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.nextStream = n;
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        return new StreamImpl<T>(this, flatMapSpliterator);
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        this.throwIfTerminated();
        final MapToObjSpliterator<? super T, ? extends IntStream> spliteratorOfStreams = new MapToObjSpliterator<T, IntStream>(mapper, this.spliterator);
        Spliterators.AbstractIntSpliterator flatMapSpliterator = new Spliterators.AbstractIntSpliterator(Long.MAX_VALUE, 0){
            IntStream nextStream;
            Spliterator.OfInt next;

            @Override
            public boolean tryAdvance(IntConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.nextStream.close();
                    this.nextStream = null;
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.nextStream = n;
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        return new IntStreamImpl(this, flatMapSpliterator);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        this.throwIfTerminated();
        final MapToObjSpliterator<? super T, ? extends LongStream> spliteratorOfStreams = new MapToObjSpliterator<T, LongStream>(mapper, this.spliterator);
        Spliterators.AbstractLongSpliterator flatMapSpliterator = new Spliterators.AbstractLongSpliterator(Long.MAX_VALUE, 0){
            LongStream nextStream;
            Spliterator.OfLong next;

            @Override
            public boolean tryAdvance(LongConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.nextStream.close();
                    this.nextStream = null;
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.nextStream = n;
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        return new LongStreamImpl(this, flatMapSpliterator);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        this.throwIfTerminated();
        final MapToObjSpliterator<? super T, ? extends DoubleStream> spliteratorOfStreams = new MapToObjSpliterator<T, DoubleStream>(mapper, this.spliterator);
        Spliterators.AbstractDoubleSpliterator flatMapSpliterator = new Spliterators.AbstractDoubleSpliterator(Long.MAX_VALUE, 0){
            DoubleStream nextStream;
            Spliterator.OfDouble next;

            @Override
            public boolean tryAdvance(DoubleConsumer action) {
                while (this.advanceToNextSpliterator()) {
                    if (this.next.tryAdvance(action)) {
                        return true;
                    }
                    this.nextStream.close();
                    this.nextStream = null;
                    this.next = null;
                }
                return false;
            }

            private boolean advanceToNextSpliterator() {
                while (this.next == null) {
                    if (spliteratorOfStreams.tryAdvance((? super T n) -> {
                        if (n != null) {
                            this.nextStream = n;
                            this.next = n.spliterator();
                        }
                    })) continue;
                    return false;
                }
                return true;
            }
        };
        return new DoubleStreamImpl(this, flatMapSpliterator);
    }

    @Override
    public Stream<T> distinct() {
        this.throwIfTerminated();
        HashSet seen = new HashSet();
        return this.filter(seen::add);
    }

    @Override
    public Stream<T> sorted() {
        this.throwIfTerminated();
        Comparator c = Comparator.naturalOrder();
        return this.sorted(c);
    }

    @Override
    public Stream<T> sorted(final Comparator<? super T> comparator) {
        this.throwIfTerminated();
        Spliterators.AbstractSpliterator sortedSpliterator = new Spliterators.AbstractSpliterator<T>(this.spliterator.estimateSize(), this.spliterator.characteristics() | 4){
            Spliterator<T> ordered;
            {
                super(size, characteristics);
                this.ordered = null;
            }

            @Override
            public Comparator<? super T> getComparator() {
                return comparator == Comparator.naturalOrder() ? null : comparator;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (this.ordered == null) {
                    ArrayList list = new ArrayList();
                    StreamImpl.this.spliterator.forEachRemaining(list::add);
                    Collections.sort(list, comparator);
                    this.ordered = list.spliterator();
                }
                return this.ordered.tryAdvance(action);
            }
        };
        return new StreamImpl<T>(this, sortedSpliterator);
    }

    @Override
    public Stream<T> peek(final Consumer<? super T> action) {
        InternalPreconditions.checkNotNull(action);
        this.throwIfTerminated();
        Spliterators.AbstractSpliterator peekSpliterator = new Spliterators.AbstractSpliterator<T>(this.spliterator.estimateSize(), this.spliterator.characteristics()){

            @Override
            public boolean tryAdvance(Consumer<? super T> innerAction) {
                return StreamImpl.this.spliterator.tryAdvance(item -> {
                    action.accept(item);
                    innerAction.accept(item);
                });
            }
        };
        return new StreamImpl<T>(this, peekSpliterator);
    }

    @Override
    public Stream<T> limit(long maxSize) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
        return new StreamImpl<T>(this, new LimitSpliterator<T>(maxSize, this.spliterator));
    }

    @Override
    public Stream<T> skip(long n) {
        this.throwIfTerminated();
        InternalPreconditions.checkState(n >= 0L, "n may not be negative");
        if (n == 0L) {
            return this;
        }
        return new StreamImpl<T>(this, new SkipSpliterator<T>(n, this.spliterator));
    }

    @Override
    public boolean isParallel() {
        this.throwIfTerminated();
        return false;
    }

    @Override
    public Stream<T> sequential() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public Stream<T> parallel() {
        this.throwIfTerminated();
        return this;
    }

    @Override
    public Stream<T> unordered() {
        this.throwIfTerminated();
        return this;
    }

    private static final class ValueConsumer<T>
    implements Consumer<T> {
        T value;

        private ValueConsumer() {
        }

        @Override
        public void accept(T value) {
            this.value = value;
        }
    }

    private static final class LimitSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final long limit;
        private final Spliterator<T> original;
        private int position = 0;

        public LimitSpliterator(long limit, Spliterator<T> original) {
            super(original.hasCharacteristics(64) ? Math.min(original.estimateSize(), limit) : Long.MAX_VALUE, original.characteristics());
            this.limit = limit;
            this.original = original;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if ((long)this.position >= this.limit) {
                return false;
            }
            boolean result = this.original.tryAdvance(action);
            ++this.position;
            return result;
        }
    }

    private static final class SkipSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private long skip;
        private final Spliterator<T> original;

        public SkipSpliterator(long skip, Spliterator<T> original) {
            super(original.hasCharacteristics(64) ? Math.max(0L, original.estimateSize() - skip) : Long.MAX_VALUE, original.characteristics());
            this.skip = skip;
            this.original = original;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            while (this.skip > 0L) {
                if (!this.original.tryAdvance(ignore -> {})) {
                    return false;
                }
                --this.skip;
            }
            return this.original.tryAdvance(action);
        }
    }

    private static final class FilterSpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Predicate<? super T> filter;
        private final Spliterator<T> original;
        private boolean found;

        public FilterSpliterator(Predicate<? super T> filter, Spliterator<T> original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFBFBF);
            InternalPreconditions.checkNotNull(filter);
            this.filter = filter;
            this.original = original;
        }

        @Override
        public Comparator<? super T> getComparator() {
            return this.original.getComparator();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            this.found = false;
            while (!this.found && this.original.tryAdvance(item -> {
                if (this.filter.test(item)) {
                    this.found = true;
                    action.accept(item);
                }
            })) {
            }
            return this.found;
        }
    }

    private static final class MapToDoubleSpliterator<T>
    extends Spliterators.AbstractDoubleSpliterator {
        private final ToDoubleFunction<? super T> map;
        private final Spliterator<T> original;

        public MapToDoubleSpliterator(ToDoubleFunction<? super T> map, Spliterator<T> original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            return this.original.tryAdvance((? super T u) -> action.accept(this.map.applyAsDouble(u)));
        }
    }

    private static final class MapToLongSpliterator<T>
    extends Spliterators.AbstractLongSpliterator {
        private final ToLongFunction<? super T> map;
        private final Spliterator<T> original;

        public MapToLongSpliterator(ToLongFunction<? super T> map, Spliterator<T> original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            return this.original.tryAdvance((? super T u) -> action.accept(this.map.applyAsLong(u)));
        }
    }

    private static final class MapToIntSpliterator<T>
    extends Spliterators.AbstractIntSpliterator {
        private final ToIntFunction<? super T> map;
        private final Spliterator<T> original;

        public MapToIntSpliterator(ToIntFunction<? super T> map, Spliterator<T> original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            return this.original.tryAdvance((? super T u) -> action.accept(this.map.applyAsInt(u)));
        }
    }

    private static final class MapToObjSpliterator<U, T>
    extends Spliterators.AbstractSpliterator<T> {
        private final Function<? super U, ? extends T> map;
        private final Spliterator<U> original;

        public MapToObjSpliterator(Function<? super U, ? extends T> map, Spliterator<U> original) {
            super(original.estimateSize(), original.characteristics() & 0xFFFFFFFA);
            InternalPreconditions.checkNotNull(map);
            this.map = map;
            this.original = original;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.original.tryAdvance(u -> action.accept((T)this.map.apply(u)));
        }
    }

    static class Empty<T>
    extends TerminatableStream<Empty<T>>
    implements Stream<T> {
        public Empty(TerminatableStream<?> previous) {
            super(previous);
        }

        @Override
        public Stream<T> filter(Predicate<? super T> predicate) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public <R> Stream<R> map(Function<? super T, ? extends R> mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream mapToInt(ToIntFunction<? super T> mapper) {
            this.throwIfTerminated();
            return new IntStreamImpl.Empty(this);
        }

        @Override
        public LongStream mapToLong(ToLongFunction<? super T> mapper) {
            this.throwIfTerminated();
            return new LongStreamImpl.Empty(this);
        }

        @Override
        public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
            this.throwIfTerminated();
            return new DoubleStreamImpl.Empty(this);
        }

        @Override
        public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
            this.throwIfTerminated();
            return new IntStreamImpl.Empty(this);
        }

        @Override
        public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
            this.throwIfTerminated();
            return new LongStreamImpl.Empty(this);
        }

        @Override
        public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
            this.throwIfTerminated();
            return new DoubleStreamImpl.Empty(this);
        }

        @Override
        public Stream<T> distinct() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public Stream<T> sorted() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public Stream<T> sorted(Comparator<? super T> comparator) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public Stream<T> peek(Consumer<? super T> action) {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public Stream<T> limit(long maxSize) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(maxSize >= 0L, "maxSize may not be negative");
            return this;
        }

        @Override
        public Stream<T> skip(long n) {
            this.throwIfTerminated();
            InternalPreconditions.checkState(n >= 0L, "n may not be negative");
            return this;
        }

        @Override
        public void forEach(Consumer<? super T> action) {
            this.terminate();
        }

        @Override
        public void forEachOrdered(Consumer<? super T> action) {
            this.terminate();
        }

        @Override
        public Object[] toArray() {
            this.terminate();
            return new Object[0];
        }

        @Override
        public <A> A[] toArray(IntFunction<A[]> generator) {
            this.terminate();
            return generator.apply(0);
        }

        @Override
        public T reduce(T identity, BinaryOperator<T> accumulator) {
            this.terminate();
            return identity;
        }

        @Override
        public Optional<T> reduce(BinaryOperator<T> accumulator) {
            this.terminate();
            return Optional.empty();
        }

        @Override
        public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
            this.terminate();
            return identity;
        }

        @Override
        public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
            this.terminate();
            return supplier.get();
        }

        @Override
        public <R, A> R collect(Collector<? super T, A, R> collector) {
            this.terminate();
            return collector.finisher().apply(collector.supplier().get());
        }

        @Override
        public Optional<T> min(Comparator<? super T> comparator) {
            this.terminate();
            return Optional.empty();
        }

        @Override
        public Optional<T> max(Comparator<? super T> comparator) {
            this.terminate();
            return Optional.empty();
        }

        @Override
        public long count() {
            this.terminate();
            return 0L;
        }

        @Override
        public boolean anyMatch(Predicate<? super T> predicate) {
            this.terminate();
            return false;
        }

        @Override
        public boolean allMatch(Predicate<? super T> predicate) {
            this.terminate();
            return true;
        }

        @Override
        public boolean noneMatch(Predicate<? super T> predicate) {
            this.terminate();
            return true;
        }

        @Override
        public Optional<T> findFirst() {
            this.terminate();
            return Optional.empty();
        }

        @Override
        public Optional<T> findAny() {
            this.terminate();
            return Optional.empty();
        }

        @Override
        public Iterator<T> iterator() {
            this.terminate();
            return Collections.emptyIterator();
        }

        @Override
        public Spliterator<T> spliterator() {
            this.terminate();
            return Spliterators.emptySpliterator();
        }

        @Override
        public boolean isParallel() {
            this.throwIfTerminated();
            return false;
        }

        @Override
        public Stream<T> sequential() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public Stream<T> parallel() {
            this.throwIfTerminated();
            return this;
        }

        @Override
        public Stream<T> unordered() {
            this.throwIfTerminated();
            return this;
        }
    }
}

