/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.ArrayList;
import java.util.List;

class TerminatableStream<T extends TerminatableStream<T>> {
    private boolean terminated = false;
    private final List<Runnable> onClose;
    private final TerminatableStream<?> root;

    public TerminatableStream(TerminatableStream<?> previous) {
        if (previous == null) {
            this.root = null;
            this.onClose = new ArrayList<Runnable>();
        } else {
            this.root = previous;
            this.onClose = null;
        }
    }

    void throwIfTerminated() {
        if (this.root != null) {
            this.root.throwIfTerminated();
        } else if (this.terminated) {
            throw new IllegalStateException("Stream already terminated, can't be modified or used");
        }
    }

    void terminate() {
        if (this.root == null) {
            this.throwIfTerminated();
            this.terminated = true;
        } else {
            this.root.terminate();
        }
    }

    public T onClose(Runnable closeHandler) {
        if (this.root == null) {
            this.onClose.add(closeHandler);
        } else {
            this.root.onClose(closeHandler);
        }
        return (T)this;
    }

    public void close() {
        if (this.root == null) {
            this.terminated = true;
            this.runClosers();
        } else {
            this.root.close();
        }
    }

    private void runClosers() {
        ArrayList throwables = new ArrayList();
        this.onClose.forEach(runnable -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                throwables.add(e);
            }
        });
        this.onClose.clear();
        if (!throwables.isEmpty()) {
            Throwable e = (Throwable)throwables.get(0);
            int size = throwables.size();
            for (int i = 1; i < size; ++i) {
                Throwable suppressed = (Throwable)throwables.get(i);
                if (suppressed == e) continue;
                e.addSuppressed(suppressed);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            assert (false) : "Couldn't have caught this exception from a Runnable! " + e;
        }
    }
}

