/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import java.util.Comparator;
import javaemul.internal.ArrayHelper;

final class MergeSorter {
    public static <T> void sort(T[] x, int fromIndex, int toIndex, Comparator<? super T> comp) {
        Object[] temp = ArrayHelper.unsafeClone(x, fromIndex, toIndex);
        MergeSorter.mergeSort(temp, x, fromIndex, toIndex, -fromIndex, comp);
    }

    private static <T> void mergeSort(T[] temp, T[] array, int low, int high, int ofs, Comparator<? super T> comp) {
        int length = high - low;
        if (length < 17) {
            MergeSorter.insertionSort(array, low, high, comp);
            return;
        }
        int tempLow = low + ofs;
        int tempHigh = high + ofs;
        int tempMid = tempLow + (tempHigh - tempLow >> 1);
        MergeSorter.mergeSort(array, temp, tempLow, tempMid, -ofs, comp);
        MergeSorter.mergeSort(array, temp, tempMid, tempHigh, -ofs, comp);
        if (comp.compare(temp[tempMid - 1], temp[tempMid]) <= 0) {
            while (low < high) {
                array[low++] = temp[tempLow++];
            }
            return;
        }
        MergeSorter.merge(temp, tempLow, tempMid, tempHigh, array, low, high, comp);
    }

    private static <T> void insertionSort(T[] array, int low, int high, Comparator<? super T> comp) {
        for (int i = low + 1; i < high; ++i) {
            T prev;
            T curr = array[i];
            for (int j = i; j > low && comp.compare(prev = array[j - 1], curr) > 0; --j) {
                array[j] = prev;
            }
            array[j] = curr;
        }
    }

    private static <T> void merge(T[] src, int srcLow, int srcMid, int srcHigh, T[] dest, int destLow, int destHigh, Comparator<T> comp) {
        int topIdx = srcMid;
        while (destLow < destHigh) {
            if (topIdx >= srcHigh || srcLow < srcMid && comp.compare(src[srcLow], src[topIdx]) <= 0) {
                dest[destLow++] = src[srcLow++];
                continue;
            }
            dest[destLow++] = src[topIdx++];
        }
    }

    private MergeSorter() {
    }
}

