/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.InternalPreconditions;
import javaemul.internal.JsUtils;
import javaemul.internal.LongUtils;
import jsinterop.annotations.JsMethod;
import jsinterop.annotations.JsType;

public final class Platform {
    @JsMethod(namespace="<global>")
    public static native boolean isNaN(double var0);

    @JsMethod(namespace="<global>")
    public static native boolean isFinite(double var0);

    public static int floatToRawIntBits(float value) {
        ArrayBuffer buf = new ArrayBuffer(4);
        ((float[])JsUtils.uncheckedCast((Object)new Float32Array((ArrayBuffer)buf)))[0] = value;
        return ((int[])JsUtils.uncheckedCast(new Uint32Array(buf)))[0] | 0;
    }

    public static float intBitsToFloat(int value) {
        ArrayBuffer buf = new ArrayBuffer(4);
        ((int[])JsUtils.uncheckedCast((Object)new Uint32Array((ArrayBuffer)buf)))[0] = value;
        return ((float[])JsUtils.uncheckedCast(new Float32Array(buf)))[0];
    }

    public static long doubleToRawLongBits(double value) {
        ArrayBuffer buf = new ArrayBuffer(8);
        ((double[])JsUtils.uncheckedCast((Object)new Float64Array((ArrayBuffer)buf)))[0] = value;
        int[] intBits = (int[])JsUtils.uncheckedCast(new Uint32Array(buf));
        return LongUtils.fromBits(intBits[0] | 0, intBits[1] | 0);
    }

    public static double longBitsToDouble(long value) {
        ArrayBuffer buf = new ArrayBuffer(8);
        int[] intBits = (int[])JsUtils.uncheckedCast(new Uint32Array(buf));
        intBits[0] = (int)value;
        intBits[1] = LongUtils.getHighBits(value);
        return ((double[])JsUtils.uncheckedCast(new Float64Array(buf)))[0];
    }

    public static int compareDouble(double x, double y) {
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        if (x == y) {
            if (x != 0.0) {
                return 0;
            }
            return (x = 1.0 / x) == (y = 1.0 / y) ? 0 : (x < y ? -1 : 1);
        }
        if (Platform.isNaN(x)) {
            if (Platform.isNaN(y)) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public static boolean objectsStringEquals(String x, String y) {
        return x == y;
    }

    public static boolean isEqual(Object x, Object y) {
        return InternalPreconditions.checkNotNull(x) == y;
    }

    public static boolean isEqual(Float x, Object y) {
        return y instanceof Float && Double.valueOf(x.doubleValue()).equals(((Float)y).doubleValue());
    }

    public static int hashCode(double x) {
        return (int)x;
    }

    public static int hashCode(float x) {
        return (int)x;
    }

    private Platform() {
    }

    @JsType(isNative=true, namespace="<global>")
    private static class Uint32Array {
        Uint32Array(ArrayBuffer buf) {
        }
    }

    @JsType(isNative=true, namespace="<global>")
    private static class Float32Array {
        Float32Array(ArrayBuffer buf) {
        }
    }

    @JsType(isNative=true, namespace="<global>")
    private static class Float64Array {
        Float64Array(ArrayBuffer buf) {
        }
    }

    @JsType(isNative=true, namespace="<global>")
    private static class ArrayBuffer {
        ArrayBuffer(int size) {
        }
    }
}

