/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.InternalPreconditions;
import javaemul.internal.LongUtils;
import jsinterop.annotations.JsType;

@JsType(namespace="vmbootstrap")
public class Primitives {
    public static int toByte(int instance) {
        return instance << 24 >> 24;
    }

    public static int toChar(int instance) {
        return instance & 0xFFFF;
    }

    public static int toShort(int instance) {
        return instance << 16 >> 16;
    }

    public static int toInt(int instance) {
        return instance | 0;
    }

    public static int widenByteToChar(int instance) {
        return Primitives.toChar(instance);
    }

    public static int narrowCharToByte(int instance) {
        return Primitives.toByte(instance);
    }

    public static int narrowCharToShort(int instance) {
        return Primitives.toShort(instance);
    }

    public static int narrowShortToByte(int instance) {
        return Primitives.toByte(instance);
    }

    public static int narrowShortToChar(int instance) {
        return Primitives.toChar(instance);
    }

    public static int narrowIntToByte(int instance) {
        return Primitives.toByte(instance);
    }

    public static int narrowIntToChar(int instance) {
        return Primitives.toChar(instance);
    }

    public static int narrowIntToShort(int instance) {
        return Primitives.toShort(instance);
    }

    public static long widenByteToLong(int instance) {
        return LongUtils.fromInt(instance);
    }

    public static long widenCharToLong(int instance) {
        return LongUtils.fromInt(instance);
    }

    public static long widenShortToLong(int instance) {
        return LongUtils.fromInt(instance);
    }

    public static long widenIntToLong(int instance) {
        return LongUtils.fromInt(instance);
    }

    public static long narrowFloatToLong(int instance) {
        return LongUtils.fromNumber(instance);
    }

    public static long narrowDoubleToLong(int instance) {
        return LongUtils.fromNumber(instance);
    }

    public static int narrowLongToByte(long instance) {
        int intValue = LongUtils.toInt(instance);
        return Primitives.toByte(intValue);
    }

    public static int narrowLongToChar(long instance) {
        int intValue = LongUtils.toInt(instance);
        return Primitives.toChar(intValue);
    }

    public static int narrowLongToShort(long instance) {
        int intValue = LongUtils.toInt(instance);
        return Primitives.toShort(intValue);
    }

    public static int narrowLongToInt(long instance) {
        return LongUtils.toInt(instance);
    }

    public static double widenLongToFloat(long instance) {
        return LongUtils.toNumber(instance);
    }

    public static double widenLongToDouble(long instance) {
        return LongUtils.toNumber(instance);
    }

    public static int narrowFloatToByte(int instance) {
        int roundInt = Primitives.roundToInt(instance);
        return Primitives.toByte(roundInt);
    }

    public static int narrowDoubleToByte(int instance) {
        int roundInt = Primitives.roundToInt(instance);
        return Primitives.toByte(roundInt);
    }

    public static int narrowFloatToChar(int instance) {
        int roundInt = Primitives.roundToInt(instance);
        return Primitives.toChar(roundInt);
    }

    public static int narrowDoubleToChar(int instance) {
        int roundInt = Primitives.roundToInt(instance);
        return Primitives.toChar(roundInt);
    }

    public static int narrowFloatToShort(int instance) {
        int roundInt = Primitives.roundToInt(instance);
        return Primitives.toShort(roundInt);
    }

    public static int narrowDoubleToShort(int instance) {
        int roundInt = Primitives.roundToInt(instance);
        return Primitives.toShort(roundInt);
    }

    public static int narrowFloatToInt(int instance) {
        return Primitives.roundToInt(instance);
    }

    public static int narrowDoubleToInt(int instance) {
        return Primitives.roundToInt(instance);
    }

    public static int coerceDivision(int value) {
        InternalPreconditions.checkArithmetic(Double.isFinite(value));
        return Primitives.toInt(value);
    }

    private static int roundToInt(int value) {
        return Primitives.toInt(Math.max(Math.min(value, Integer.MAX_VALUE), Integer.MIN_VALUE));
    }
}

