/*
 * Decompiled with CFR 0.152.
 */
package javaemul.internal;

import javaemul.internal.NativeRegExp;

public final class StringUtil {
    private static final String whitespaceRegexStr = "[\\u1680\\u180E\\u2000-\\u2006\\u2008-\\u200A\\u2028\\u2029\\u205F\\u3000\\uFEFF]|[\\t-\\r ]|[\\x1C-\\x1F]";
    private static NativeRegExp whitespaceRegex;
    private static final String spaceRegexStr = "[\\u0020\\u00A0\\u1680\\u2000-\\u200A\\u202F\\u2028\\u2029\\u205F\\u3000]";
    private static NativeRegExp spaceRegex;
    private static NativeRegExp whitespaceOrSpaceRegex;

    public static boolean isWhitespace(String str) {
        if (whitespaceRegex == null) {
            whitespaceRegex = new NativeRegExp("^([\\u1680\\u180E\\u2000-\\u2006\\u2008-\\u200A\\u2028\\u2029\\u205F\\u3000\\uFEFF]|[\\t-\\r ]|[\\x1C-\\x1F])+$");
        }
        return whitespaceRegex.test(str);
    }

    public static boolean isSpace(String str) {
        if (spaceRegex == null) {
            spaceRegex = new NativeRegExp("^([\\u0020\\u00A0\\u1680\\u2000-\\u200A\\u202F\\u2028\\u2029\\u205F\\u3000])+$");
        }
        return spaceRegex.test(str);
    }

    public static boolean isWhitespaceOrSpace(String str) {
        if (whitespaceOrSpaceRegex == null) {
            whitespaceOrSpaceRegex = new NativeRegExp("^([\\u1680\\u180E\\u2000-\\u2006\\u2008-\\u200A\\u2028\\u2029\\u205F\\u3000\\uFEFF]|[\\t-\\r ]|[\\x1C-\\x1F]|[\\u0020\\u00A0\\u1680\\u2000-\\u200A\\u202F\\u2028\\u2029\\u205F\\u3000])+$");
        }
        return whitespaceOrSpaceRegex.test(str);
    }

    public static String replace(String str, char from, char to, boolean ignoreCase) {
        return StringUtil.nativeReplace(str, StringUtil.escapeForRegExpSearch(from), to, true, ignoreCase);
    }

    public static String replace(String str, CharSequence from, CharSequence to, boolean ignoreCase) {
        return StringUtil.nativeReplace(str, StringUtil.escapeForRegExpSearch(from), StringUtil.escapeForRegExpSearch(to), true, ignoreCase);
    }

    public static String replaceAll(String str, String regex, String replace, boolean ignoreCase) {
        return StringUtil.nativeReplace(str, regex, replace, true, ignoreCase);
    }

    public static String replaceFirst(String str, String regex, String replace, boolean ignoreCase) {
        return StringUtil.nativeReplace(str, regex, replace, false, ignoreCase);
    }

    public static String replaceFirstLiteral(String str, char from, char to, boolean ignoreCase) {
        return StringUtil.nativeReplace(str, StringUtil.escapeForRegExpSearch(from), to, false, ignoreCase);
    }

    public static String replaceFirstLiteral(String str, CharSequence from, CharSequence to, boolean ignoreCase) {
        return StringUtil.nativeReplace(str, StringUtil.escapeForRegExpSearch(from), StringUtil.escapeForRegExpReplacement(to), false, ignoreCase);
    }

    private static String nativeReplace(String str, String regex, String replace, boolean replaceAll, boolean ignoreCase) {
        String flags = (replaceAll ? "g" : "") + (ignoreCase ? "i" : "");
        return str.nativeReplace(new NativeRegExp(regex, flags), StringUtil.translateReplaceString(replace));
    }

    private static String nativeReplace(String str, String regex, char replace, boolean replaceAll, boolean ignoreCase) {
        String flags = (replaceAll ? "g" : "") + (ignoreCase ? "i" : "");
        return str.nativeReplace(new NativeRegExp(regex, flags), replace);
    }

    private static String translateReplaceString(String replaceStr) {
        int pos = 0;
        while (0 <= (pos = replaceStr.indexOf("\\", pos))) {
            if (replaceStr.charAt(pos + 1) == '$') {
                replaceStr = replaceStr.substring(0, pos) + "$" + replaceStr.substring(++pos);
                continue;
            }
            replaceStr = replaceStr.substring(0, pos) + replaceStr.substring(++pos);
        }
        return replaceStr;
    }

    private static String escapeForRegExpSearch(char c) {
        String hex = Integer.toHexString(c);
        return "\\u" + "0000".substring(hex.length()) + hex;
    }

    private static String escapeForRegExpSearch(CharSequence str) {
        return str.toString().replaceAll("([/\\\\\\.\\*\\+\\?\\|\\(\\)\\[\\]\\{\\}$^])", "\\\\$1");
    }

    private static String escapeForRegExpReplacement(CharSequence str) {
        return str.toString().toString().replaceAll("\\\\", "\\\\\\\\").replaceAll("\\$", "\\\\$");
    }

    private StringUtil() {
    }
}

