/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.pmml;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kie.api.definition.type.PropertyReactive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PropertyReactive
@XmlType(name="PMML4Result")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="pmml4Result")
public class PMML4Result {
    private static final Logger LOG = LoggerFactory.getLogger(PMML4Result.class);
    @XmlAttribute(name="correlationId", required=true)
    private String correlationId;
    @XmlElement(name="segmentationId")
    private String segmentationId;
    @XmlElement(name="segmentId")
    private String segmentId;
    @XmlElement(name="segmentIndex")
    private int segmentIndex;
    @XmlAttribute(name="resultCode", required=true)
    private String resultCode;
    @XmlAttribute(name="resultObjectName")
    private String resultObjectName;
    @XmlElementWrapper(name="resultVariables")
    private Map<String, Object> resultVariables;

    public PMML4Result() {
        this.resultVariables = new HashMap<String, Object>();
    }

    public PMML4Result(String correlationId) {
        this.correlationId = correlationId;
        this.resultVariables = new HashMap<String, Object>();
    }

    public String getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getSegmentationId() {
        return this.segmentationId;
    }

    public void setSegmentationId(String segmentationId) {
        this.segmentationId = segmentationId;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    public String getResultObjectName() {
        return this.resultObjectName;
    }

    public void setResultObjectName(String resultObjectName) {
        this.resultObjectName = resultObjectName;
    }

    public Map<String, Object> getResultVariables() {
        if (this.resultVariables == null) {
            this.resultVariables = new HashMap<String, Object>();
        }
        return this.resultVariables;
    }

    public void updateResultVariable(String objName, Object obj) {
        if (this.resultVariables == null) {
            this.resultVariables = new HashMap<String, Object>();
        }
        this.resultVariables.put(objName, obj);
    }

    public void setResultVariables(Map<String, Object> resultVariables) {
        this.resultVariables = resultVariables;
    }

    public void addResultVariable(String objName, Object object) {
        if (this.resultVariables == null) {
            this.resultVariables = new HashMap<String, Object>();
        }
        this.resultVariables.put(objName, object);
    }

    private String getGetterMethodName(Object wrapper, String fieldName, String prefix) {
        String capFieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        return prefix + capFieldName;
    }

    public <T> Optional<T> getResultValue(String objName, String objField, Class<T> clazz, Object ... params) {
        Object value = null;
        Object obj = this.getResultValue(objName, objField, params);
        if (clazz != null && obj != null && clazz.isAssignableFrom(obj.getClass())) {
            value = obj;
        }
        return value != null ? Optional.of(value) : Optional.empty();
    }

    public Object getResultValue(String objName, String objField, Object ... params) {
        Object value;
        block18: {
            value = null;
            Object holder = this.getResultVariables().get(objName);
            if (holder != null) {
                if (objField != null && !objField.trim().isEmpty()) {
                    if (Map.class.isAssignableFrom(holder.getClass())) {
                        value = ((Map)holder).get(objField);
                        return value;
                    }
                    String defFldRetriever = this.getGetterMethodName(holder, objField, "get");
                    try {
                        Class[] paramTypes = null;
                        Method m = null;
                        boolean retry = true;
                        if (params != null && params.length > 0) {
                            paramTypes = new Class[params.length];
                            for (int x = 0; x < params.length; ++x) {
                                paramTypes[x] = params[x].getClass();
                            }
                            do {
                                try {
                                    m = holder.getClass().getMethod(defFldRetriever, paramTypes);
                                }
                                catch (NoSuchMethodException nsmx) {
                                    if (m == null && defFldRetriever.startsWith("get")) {
                                        defFldRetriever = this.getGetterMethodName(holder, objField, "is");
                                        continue;
                                    }
                                    retry = false;
                                }
                            } while (m == null && retry);
                        } else {
                            do {
                                try {
                                    m = holder.getClass().getMethod(defFldRetriever, new Class[0]);
                                }
                                catch (NoSuchMethodException nsmx) {
                                    if (m == null && defFldRetriever.startsWith("get")) {
                                        defFldRetriever = this.getGetterMethodName(holder, objField, "is");
                                        continue;
                                    }
                                    retry = false;
                                }
                            } while (m == null && retry);
                        }
                        if (m == null) break block18;
                        if (params != null && params.length > 0) {
                            value = m.invoke(holder, params);
                            break block18;
                        }
                        value = m.invoke(holder, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e1) {
                        LOG.error("Exception", (Throwable)e1);
                    }
                } else {
                    value = holder;
                }
            }
        }
        return value;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationId == null ? 0 : this.correlationId.hashCode());
        result = 31 * result + (this.segmentId == null ? 0 : this.segmentId.hashCode());
        result = 31 * result + this.segmentIndex;
        result = 31 * result + (this.segmentationId == null ? 0 : this.segmentationId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PMML4Result other = (PMML4Result)obj;
        if (this.correlationId == null ? other.correlationId != null : !this.correlationId.equals(other.correlationId)) {
            return false;
        }
        if (this.segmentId == null ? other.segmentId != null : !this.segmentId.equals(other.segmentId)) {
            return false;
        }
        if (this.segmentIndex != other.segmentIndex) {
            return false;
        }
        return !(this.segmentationId == null ? other.segmentationId != null : !this.segmentationId.equals(other.segmentationId));
    }

    public String toString() {
        return "PMML4Result [correlationId=" + this.correlationId + ", segmentationId=" + this.segmentationId + ", segmentId=" + this.segmentId + ", segmentIndex=" + this.segmentIndex + ", resultCode=" + this.resultCode + ", resultVariables=" + this.resultVariables + "]";
    }
}

