/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver.callback.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class WebSocketServerHandler
extends SimpleChannelInboundHandler<Object> {
    private WebSocketServerHandshaker handshaker;

    private static String getWebSocketLocation(FullHttpRequest req) {
        return "ws://" + req.headers().get("Host") + "/websocket";
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) {
        if ("/websocket".equals(req.getUri())) {
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(WebSocketServerHandler.getWebSocketLocation(req), null, true);
            this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
            if (this.handshaker == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
            } else {
                this.handshaker.handshake(ctx.channel(), req);
            }
        } else if ("/".equals(req.getUri())) {
            ByteBuf content = WebSocketServerHandler.getContent(WebSocketServerHandler.getWebSocketLocation(req));
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
            res.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
            HttpHeaders.setContentLength((HttpMessage)res, (long)content.readableBytes());
            ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
            if (!HttpHeaders.isKeepAlive((HttpMessage)req)) {
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        } else {
            ctx.channel().writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void handleWebSocketFrame(final ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
        } else if (frame instanceof TextWebSocketFrame) {
            String request = ((TextWebSocketFrame)frame).text();
            if (request.startsWith("connect")) {
                final String id = StringUtils.substringAfter((String)request, (String)"connect");
                System.out.println("Received connection from: " + id);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 1; i <= 10; ++i) {
                            ctx.channel().writeAndFlush((Object)new TextWebSocketFrame("sending message " + i + " to " + id));
                            try {
                                TimeUnit.SECONDS.sleep(1L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        ctx.channel().writeAndFlush((Object)new CloseWebSocketFrame());
                    }
                }).start();
            }
        } else {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    public static ByteBuf getContent(String webSocketLocation) {
        return Unpooled.copiedBuffer((CharSequence)("<html>\r\n<head>\r\n<title>Web Socket JS Client</title>\r\n</head>\r\n<body>\r\n<script type=\"text/javascript\">\r\nvar socket;\r\nif (!window.WebSocket) {\r\n  window.WebSocket = window.MozWebSocket;\r\n}\r\n\r\nif (window.WebSocket) {\r\n  socket = new WebSocket(\"" + webSocketLocation + "\");" + "\r\n" + "  socket.onmessage = function(event) {" + "\r\n" + "    var messageBox = document.getElementById('messageBox');" + "\r\n" + "    messageBox.value = messageBox.value + '\\n' + event.data" + "\r\n" + "  };" + "\r\n" + "  socket.onopen = function(event) {" + "\r\n" + "    var messageBox = document.getElementById('messageBox');" + "\r\n" + "    messageBox.value = \"Web Socket opened!\";" + "\r\n" + "    send(\"connect\" + createUUID());" + "\r\n" + "  };" + "\r\n" + "  socket.onclose = function(event) {" + "\r\n" + "    var messageBox = document.getElementById('messageBox');" + "\r\n" + "    messageBox.value = messageBox.value + \"\\nWeb Socket closed\"; " + "\r\n" + "  };" + "\r\n" + "} else {" + "\r\n" + "  alert(\"Your browser does not support Web Socket.\");" + "\r\n" + "}" + "\r\n" + "\r\n" + "function send(message) {" + "\r\n" + "  if (!window.WebSocket) { return; }" + "\r\n" + "  if (socket.readyState == WebSocket.OPEN) {" + "\r\n" + "    socket.send(message);" + "\r\n" + "  } else {" + "\r\n" + "    alert(\"The socket is not open.\");" + "\r\n" + "  }" + "\r\n" + "}" + "\r\n" + "\r\n" + "function createUUID() {" + "\r\n" + "    var s = [];" + "\r\n" + "    var hexDigits = \"0123456789abcdef\";" + "\r\n" + "    for (var i = 0; i < 36; i++) {" + "\r\n" + "        s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);" + "\r\n" + "    }" + "\r\n" + "    s[14] = \"4\";  // bits 12-15 of the time_hi_and_version field to 0010" + "\r\n" + "    s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01" + "\r\n" + "    s[8] = s[13] = s[18] = s[23] = \"-\";" + "\r\n" + "    var uuid = s.join(\"\");" + "\r\n" + "    return uuid;" + "\r\n" + "}" + "\r\n" + "\r\n" + "</script>" + "\r\n" + "<textarea id=\"messageBox\" style=\"width:500px;height:300px;\"></textarea>" + "\r\n" + "</body>" + "\r\n" + "</html>" + "\r\n"), (Charset)CharsetUtil.US_ASCII);
    }
}

