/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.schematic;

import java.util.Objects;
import org.modeshape.schematic.document.Document;
import org.modeshape.schematic.internal.document.BasicDocument;

@FunctionalInterface
public interface SchematicEntry {
    public Document source();

    default public Document getMetadata() {
        return this.source().getDocument("metadata");
    }

    default public Document content() {
        return SchematicEntry.content(this.source());
    }

    default public String id() {
        return SchematicEntry.id(this.source());
    }

    public static SchematicEntry create(String id) {
        return SchematicEntry.create(id, new BasicDocument());
    }

    public static SchematicEntry create(String id, Document content) {
        id = Objects.requireNonNull(id, "id cannot be null");
        content = Objects.requireNonNull(content, "content cannot be null");
        BasicDocument source = new BasicDocument("metadata", new BasicDocument("id", id), "content", content);
        return () -> source;
    }

    public static String id(Document entryDocument) {
        Document metadata = entryDocument.getDocument("metadata");
        if (metadata == null) {
            return null;
        }
        return metadata.getString("id");
    }

    public static Document content(Document entryDocument) {
        return entryDocument.getDocument("content");
    }

    public static abstract class FieldName {
        protected static final String METADATA = "metadata";
        protected static final String CONTENT = "content";
        protected static final String ID = "id";

        private FieldName() {
        }
    }
}

