/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionManager;
import org.mybatis.guice.mappers.MapperProvider;
import org.mybatis.guice.session.SqlSessionManagerProvider;
import org.mybatis.guice.transactional.Transactional;
import org.mybatis.guice.transactional.TransactionalMethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractMyBatisModule
extends AbstractModule {
    private ClassLoader resourcesClassLoader = this.getDefaultClassLoader();
    private ClassLoader driverClassLoader = this.getDefaultClassLoader();

    AbstractMyBatisModule() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void configure() {
        try {
            this.bind(SqlSessionManager.class).toProvider(SqlSessionManagerProvider.class).in(Scopes.SINGLETON);
            this.bind(SqlSession.class).to(SqlSessionManager.class).in(Scopes.SINGLETON);
            TransactionalMethodInterceptor interceptor = new TransactionalMethodInterceptor();
            this.requestInjection(interceptor);
            this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{interceptor});
            this.bindInterceptor(Matchers.annotatedWith(Transactional.class), Matchers.not((Matcher)Matchers.annotatedWith(Transactional.class)), new MethodInterceptor[]{interceptor});
            this.internalConfigure();
            this.bind(ClassLoader.class).annotatedWith((Annotation)Names.named((String)"JDBC.driverClassLoader")).toInstance((Object)this.driverClassLoader);
            Object var3_2 = null;
            this.resourcesClassLoader = this.getDefaultClassLoader();
            this.driverClassLoader = this.getDefaultClassLoader();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.resourcesClassLoader = this.getDefaultClassLoader();
            this.driverClassLoader = this.getDefaultClassLoader();
            throw throwable;
        }
    }

    final <T> void bindMapper(Class<T> mapperType) {
        this.bind(mapperType).toProvider(Providers.guicify(new MapperProvider<T>(mapperType))).in(Scopes.SINGLETON);
    }

    public void useResourceClassLoader(ClassLoader resourceClassLoader) {
        this.resourcesClassLoader = resourceClassLoader;
    }

    protected final ClassLoader getResourceClassLoader() {
        return this.resourcesClassLoader;
    }

    public void useJdbcDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    private ClassLoader getDefaultClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    abstract void internalConfigure();

    protected abstract void initialize();
}

