/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.datasource.dbcp;

import com.google.inject.Provider;
import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp.datasources.SharedPoolDataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SharedPoolDataSourceProvider
implements Provider<DataSource> {
    private final SharedPoolDataSource dataSource = new SharedPoolDataSource();

    @Inject
    public SharedPoolDataSourceProvider(ConnectionPoolDataSource cpds) {
        this.dataSource.setConnectionPoolDataSource(cpds);
    }

    @com.google.inject.Inject(optional=true)
    public void setDataSourceName(@Named(value="DBCP.name") String name) {
        this.dataSource.setDataSourceName(name);
    }

    @com.google.inject.Inject(optional=true)
    public void setDefaultAutoCommit(@Named(value="JDBC.autoCommit") boolean autoCommit) {
        this.dataSource.setDefaultAutoCommit(autoCommit);
    }

    @com.google.inject.Inject(optional=true)
    public void setDefaultReadOnly(@Named(value="DBCP.defaultReadOnly") boolean defaultReadOnly) {
        this.dataSource.setDefaultReadOnly(defaultReadOnly);
    }

    @com.google.inject.Inject(optional=true)
    public void setDefaultTransactionIsolation(@Named(value="DBCP.defaultTransactionIsolation") int defaultTransactionIsolation) {
        this.dataSource.setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    @com.google.inject.Inject(optional=true)
    public void setDescription(@Named(value="DBCP.description") String description) {
        this.dataSource.setDescription(description);
    }

    @com.google.inject.Inject(optional=true)
    public void setJndiEnvironment(@Named(value="DBCP.jndi.key") String key, @Named(value="DBCP.jndi.value") String value) {
        this.dataSource.setJndiEnvironment(key, value);
    }

    @com.google.inject.Inject(optional=true)
    public void setLoginTimeout(@Named(value="JDBC.loginTimeout") int loginTimeout) {
        this.dataSource.setLoginTimeout(loginTimeout);
    }

    @com.google.inject.Inject(optional=true)
    public void setMinEvictableIdleTimeMillis(@Named(value="DBCP.minEvictableIdleTimeMillis") int minEvictableIdleTimeMillis) {
        this.dataSource.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    @com.google.inject.Inject(optional=true)
    public void setNumTestsPerEvictionRun(@Named(value="DBCP.numTestsPerEvictionRun") int numTestsPerEvictionRun) {
        this.dataSource.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    @com.google.inject.Inject(optional=true)
    public void setRollbackAfterValidation(@Named(value="DBCP.rollbackAfterValidation") boolean rollbackAfterValidation) {
        this.dataSource.setRollbackAfterValidation(rollbackAfterValidation);
    }

    @com.google.inject.Inject(optional=true)
    public void setTestOnBorrow(@Named(value="DBCP.testOnBorrow") boolean testOnBorrow) {
        this.dataSource.setTestOnBorrow(testOnBorrow);
    }

    @com.google.inject.Inject(optional=true)
    public void setTestOnReturn(@Named(value="DBCP.testOnReturn") boolean testOnReturn) {
        this.dataSource.setTestOnReturn(testOnReturn);
    }

    @com.google.inject.Inject(optional=true)
    public void setTestWhileIdle(@Named(value="DBCP.testWhileIdle") boolean testWhileIdle) {
        this.dataSource.setTestWhileIdle(testWhileIdle);
    }

    @com.google.inject.Inject(optional=true)
    public void setTimeBetweenEvictionRunsMillis(@Named(value="DBCP.timeBetweenEvictionRunsMillis") int timeBetweenEvictionRunsMillis) {
        this.dataSource.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    @com.google.inject.Inject(optional=true)
    public void setValidationQuery(@Named(value="DBCP.validationQuery") String validationQuery) {
        this.dataSource.setValidationQuery(validationQuery);
    }

    @com.google.inject.Inject(optional=true)
    public void setMaxActive(@Named(value="DBCP.maxActive") int maxActive) {
        this.dataSource.setMaxActive(maxActive);
    }

    @com.google.inject.Inject(optional=true)
    public void setMaxIdle(@Named(value="DBCP.maxIdle") int maxIdle) {
        this.dataSource.setMaxIdle(maxIdle);
    }

    @com.google.inject.Inject(optional=true)
    public void setMaxWait(@Named(value="DBCP.maxWait") int maxWait) {
        this.dataSource.setMaxWait(maxWait);
    }

    public DataSource get() {
        return this.dataSource;
    }
}

