/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionParameters;
import org.neo4j.bolt.connection.BoltConnectionSource;
import org.neo4j.bolt.connection.RoutedBoltConnectionParameters;

public final class SingleRoutedBoltConnectionSource
implements BoltConnectionSource<RoutedBoltConnectionParameters> {
    private final BoltConnectionSource<BoltConnectionParameters> delegate;

    public SingleRoutedBoltConnectionSource(BoltConnectionSource<BoltConnectionParameters> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public CompletionStage<BoltConnection> getConnection() {
        return this.delegate.getConnection();
    }

    public CompletionStage<BoltConnection> getConnection(RoutedBoltConnectionParameters parameters) {
        return this.delegate.getConnection((BoltConnectionParameters)parameters).whenComplete((connection, throwable) -> {
            if (throwable == null) {
                parameters.databaseNameListener().accept(parameters.databaseName());
            }
        });
    }

    public CompletionStage<Void> verifyConnectivity() {
        return this.delegate.verifyConnectivity();
    }

    public CompletionStage<Boolean> supportsMultiDb() {
        return this.delegate.supportsMultiDb();
    }

    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.delegate.supportsSessionAuth();
    }

    public CompletionStage<Void> close() {
        return this.delegate.close();
    }
}

