/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.Map;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;

abstract class CollectorStateMachine<DATA> {
    private State state = State.IDLE;
    private long collectionId;

    static Result success(String message) {
        return new Result(true, message);
    }

    static Result error(String message) {
        return new Result(false, message);
    }

    CollectorStateMachine() {
    }

    public synchronized Status status() {
        State state = this.state;
        switch (state) {
            case IDLE: {
                return new Status("idle");
            }
            case COLLECTING: {
                return new Status("collecting");
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)state));
    }

    public synchronized Result collect(Map<String, Object> config) throws InvalidArgumentsException {
        switch (this.state) {
            case IDLE: {
                this.state = State.COLLECTING;
                ++this.collectionId;
                return this.doCollect(config, this.collectionId);
            }
            case COLLECTING: {
                return CollectorStateMachine.success("Collection is already ongoing.");
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
    }

    public synchronized Result stop(long collectionIdToStop) {
        switch (this.state) {
            case IDLE: {
                return CollectorStateMachine.success("Collector is idle, no collection ongoing.");
            }
            case COLLECTING: {
                if (this.collectionId <= collectionIdToStop) {
                    this.state = State.IDLE;
                    return this.doStop();
                }
                return CollectorStateMachine.success(String.format("Collection event %d has already been stopped, a new collection event is ongoing.", collectionIdToStop));
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
    }

    public synchronized Result clear() {
        switch (this.state) {
            case IDLE: {
                return this.doClear();
            }
            case COLLECTING: {
                return CollectorStateMachine.error("Collected data cannot be cleared while collecting.");
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
    }

    public synchronized DATA getData() {
        switch (this.state) {
            case IDLE: {
                return this.doGetData();
            }
            case COLLECTING: {
                throw new IllegalStateException("Collector is still collecting.");
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)this.state));
    }

    abstract Result doCollect(Map<String, Object> var1, long var2) throws InvalidArgumentsException;

    abstract Result doStop();

    abstract Result doClear();

    abstract DATA doGetData();

    static final class Result {
        final boolean success;
        final String message;

        Result(boolean success, String message) {
            this.success = success;
            this.message = message;
        }
    }

    static final class Status {
        final String message;

        Status(String message) {
            this.message = message;
        }
    }

    private static enum State {
        IDLE,
        COLLECTING;

    }
}

