/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.collector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.collector.Anonymizer;
import org.neo4j.internal.collector.RetrieveResult;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

final class GraphCountsSection {
    private GraphCountsSection() {
    }

    static Stream<RetrieveResult> retrieve(Kernel kernel, Anonymizer anonymizer) throws TransactionFailureException, IndexNotFoundKernelException {
        try (Transaction tx = kernel.beginTransaction(Transaction.Type.explicit, LoginContext.AUTH_DISABLED);){
            TokenRead tokens = tx.tokenRead();
            Read read = tx.dataRead();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("nodes", GraphCountsSection.nodeCounts(tokens, read, anonymizer));
            data.put("relationships", GraphCountsSection.relationshipCounts(tokens, read, anonymizer));
            data.put("indexes", GraphCountsSection.indexes(tokens, tx.schemaRead(), anonymizer));
            data.put("constraints", GraphCountsSection.constraints(tokens, tx.schemaRead(), anonymizer));
            Stream<RetrieveResult> stream = Stream.of(new RetrieveResult("GRAPH COUNTS", data));
            return stream;
        }
    }

    private static List<Map<String, Object>> nodeCounts(TokenRead tokens, Read read, Anonymizer anonymizer) {
        ArrayList<Map<String, Object>> nodeCounts = new ArrayList<Map<String, Object>>();
        HashMap<String, Long> nodeCount = new HashMap<String, Long>();
        nodeCount.put("count", read.countsForNodeWithoutTxState(-1));
        nodeCounts.add(nodeCount);
        tokens.labelsGetAllTokens().forEachRemaining(t -> {
            long count = read.countsForNodeWithoutTxState(t.id());
            HashMap<String, Object> labelCount = new HashMap<String, Object>();
            labelCount.put("label", anonymizer.label(t.name(), t.id()));
            labelCount.put("count", count);
            nodeCounts.add(labelCount);
        });
        return nodeCounts;
    }

    private static List<Map<String, Object>> relationshipCounts(TokenRead tokens, Read read, Anonymizer anonymizer) {
        ArrayList<Map<String, Object>> relationshipCounts = new ArrayList<Map<String, Object>>();
        HashMap<String, Long> relationshipCount = new HashMap<String, Long>();
        relationshipCount.put("count", read.countsForRelationshipWithoutTxState(-1, -1, -1));
        relationshipCounts.add(relationshipCount);
        List labels = Iterators.asList((Iterator)tokens.labelsGetAllTokens());
        tokens.relationshipTypesGetAllTokens().forEachRemaining(t -> {
            long count = read.countsForRelationshipWithoutTxState(-1, t.id(), -1);
            HashMap<String, Object> relationshipTypeCount = new HashMap<String, Object>();
            relationshipTypeCount.put("relationshipType", anonymizer.relationshipType(t.name(), t.id()));
            relationshipTypeCount.put("count", count);
            relationshipCounts.add(relationshipTypeCount);
            for (NamedToken label : labels) {
                long endCount;
                long startCount = read.countsForRelationshipWithoutTxState(label.id(), t.id(), -1);
                if (startCount > 0L) {
                    HashMap<String, Object> x = new HashMap<String, Object>();
                    x.put("relationshipType", anonymizer.relationshipType(t.name(), t.id()));
                    x.put("startLabel", anonymizer.label(label.name(), label.id()));
                    x.put("count", startCount);
                    relationshipCounts.add(x);
                }
                if ((endCount = read.countsForRelationshipWithoutTxState(-1, t.id(), label.id())) <= 0L) continue;
                HashMap<String, Object> x = new HashMap<String, Object>();
                x.put("relationshipType", anonymizer.relationshipType(t.name(), t.id()));
                x.put("endLabel", anonymizer.label(label.name(), label.id()));
                x.put("count", endCount);
                relationshipCounts.add(x);
            }
        });
        return relationshipCounts;
    }

    private static List<Map<String, Object>> indexes(TokenRead tokens, SchemaRead schemaRead, Anonymizer anonymizer) throws IndexNotFoundKernelException {
        ArrayList<Map<String, Object>> indexes = new ArrayList<Map<String, Object>>();
        SilentTokenNameLookup tokenLookup = new SilentTokenNameLookup(tokens);
        Iterator iterator = schemaRead.indexesGetAll();
        while (iterator.hasNext()) {
            IndexReference index = (IndexReference)iterator.next();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("labels", GraphCountsSection.map(index.schema().getEntityTokenIds(), id -> anonymizer.label(tokenLookup.labelGetName(id), id)));
            data.put("properties", GraphCountsSection.map(index.schema().getPropertyIds(), id -> anonymizer.propertyKey(tokenLookup.propertyKeyGetName(id), id)));
            Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
            schemaRead.indexUpdatesAndSize(index, register);
            data.put("totalSize", register.readSecond());
            data.put("updatesSinceEstimation", register.readFirst());
            schemaRead.indexSample(index, register);
            data.put("estimatedUniqueSize", register.readFirst());
            indexes.add(data);
        }
        return indexes;
    }

    private static List<Map<String, Object>> constraints(TokenRead tokens, SchemaRead schemaRead, Anonymizer anonymizer) {
        ArrayList<Map<String, Object>> constraints = new ArrayList<Map<String, Object>>();
        SilentTokenNameLookup tokenLookup = new SilentTokenNameLookup(tokens);
        Iterator iterator = schemaRead.constraintsGetAll();
        while (iterator.hasNext()) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)iterator.next();
            HashMap<String, Object> data = new HashMap<String, Object>();
            int labelId = constraint.schema().getEntityTokenIds()[0];
            data.put("label", anonymizer.label(tokenLookup.labelGetName(labelId), labelId));
            data.put("properties", GraphCountsSection.map(constraint.schema().getPropertyIds(), id -> anonymizer.propertyKey(tokenLookup.propertyKeyGetName(id), id)));
            data.put("type", GraphCountsSection.constraintType(constraint));
            constraints.add(data);
        }
        return constraints;
    }

    private static List<String> map(int[] ids, IntFunction<String> f) {
        return Arrays.stream(ids).mapToObj(f).collect(Collectors.toList());
    }

    private static String constraintType(ConstraintDescriptor constraint) {
        switch (constraint.type()) {
            case EXISTS: {
                return "Existence constraint";
            }
            case UNIQUE: {
                return "Uniqueness constraint";
            }
            case UNIQUE_EXISTS: {
                return "Node Key";
            }
        }
        throw new IllegalArgumentException("Unknown constraint type: " + constraint.type());
    }
}

