/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator;

import java.util.HashMap;
import java.util.Map;
import org.openapi4j.core.model.OAI;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.v3.ValidatorInstance;

public class ValidationContext<O extends OAI> {
    private final OAIContext context;
    private final Map<String, JsonValidator> visitedRefs = new HashMap<String, JsonValidator>();
    private final Map<Byte, Boolean> defaultOptions = new HashMap<Byte, Boolean>();
    private final Map<String, ValidatorInstance> additionalValidators = new HashMap<String, ValidatorInstance>();
    private boolean isFastFail;

    public ValidationContext(OAIContext context) {
        this.context = context;
    }

    public OAIContext getContext() {
        return this.context;
    }

    public boolean isFastFail() {
        return this.isFastFail;
    }

    public ValidationContext<O> setFastFail(boolean fastFail) {
        this.isFastFail = fastFail;
        return this;
    }

    public ValidationContext<O> addReference(String ref, JsonValidator validator) {
        this.visitedRefs.put(ref, validator);
        return this;
    }

    public JsonValidator getReference(String ref) {
        return this.visitedRefs.get(ref);
    }

    public ValidationContext<O> setOption(byte option, boolean value) {
        this.defaultOptions.put(option, value);
        return this;
    }

    public boolean getOption(byte option) {
        return Boolean.TRUE.equals(this.defaultOptions.get(option));
    }

    public Map<String, ValidatorInstance> getValidators() {
        return this.additionalValidators;
    }

    public ValidationContext<O> addValidator(String keyword, ValidatorInstance validatorInstantiation) {
        this.additionalValidators.put(keyword, validatorInstantiation);
        return this;
    }
}

