/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.DiscriminatorValidator;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class AnyOfValidator
extends DiscriminatorValidator {
    private static final String ERR_MSG = "No valid schema.";

    static AnyOfValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new AnyOfValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private AnyOfValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema, "anyOf");
    }

    @Override
    void validateWithoutDiscriminator(JsonNode valueNode, ValidationResults results) {
        for (SchemaValidator schema : this.schemas) {
            try {
                schema.validate(valueNode);
                return;
            }
            catch (ValidationException validationException) {
            }
        }
        results.addError(ERR_MSG, "anyOf");
    }
}

