/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class DependenciesValidator
extends BaseJsonValidator<OAI3> {
    private static final String MISSING_DEP_ERR_MSG = "Missing dependency '%s' from '%s' definition.";
    private final Map<String, Collection<String>> arrayDependencies = new HashMap<String, Collection<String>>();
    private final Map<String, SchemaValidator> objectDependencies = new HashMap<String, SchemaValidator>();

    static DependenciesValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new DependenciesValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private DependenciesValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        Iterator fieldNames = schemaNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode fieldSchemaVal = schemaNode.get(fieldName);
            if (fieldSchemaVal.isObject()) {
                this.objectDependencies.put(fieldName, new SchemaValidator(context, fieldName, fieldSchemaVal, schemaParentNode, parentSchema));
                continue;
            }
            if (!fieldSchemaVal.isArray()) continue;
            Collection values = this.arrayDependencies.computeIfAbsent(fieldName, k -> new ArrayList());
            for (int i = 0; i < fieldSchemaVal.size(); ++i) {
                values.add(fieldSchemaVal.get(i).asText());
            }
        }
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        Iterator fieldNames = valueNode.fieldNames();
        this.validate(() -> {
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                Collection<String> values = this.arrayDependencies.get(fieldName);
                if (values != null) {
                    this.validateArray(valueNode, values, results);
                    continue;
                }
                this.validateObject(valueNode, this.objectDependencies.get(fieldName), results);
            }
        });
    }

    private void validateArray(JsonNode valueNode, Collection<String> values, ValidationResults results) {
        for (String field : values) {
            if (valueNode.get(field) != null) continue;
            results.addError(String.format(MISSING_DEP_ERR_MSG, field, this.arrayDependencies.toString()), "dependencies");
        }
    }

    private void validateObject(JsonNode valueNode, SchemaValidator schema, ValidationResults results) throws ValidationException {
        if (schema != null) {
            schema.validateWithContext(valueNode, results);
        }
    }
}

