/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

abstract class DiscriminatorValidator
extends BaseJsonValidator<OAI3> {
    private static final String INVALID_SCHEMA = "Schema selection can't be made for discriminator '%s'.";
    private static final String INVALID_PROPERTY = "Property name in schema is not set.";
    private static final String INVALID_PROPERTY_CONTENT = "Property name in content '%s' is not set.";
    private static final String SCHEMAS_PATH = "#/components/schemas/";
    final List<SchemaValidator> schemas = new ArrayList<SchemaValidator>();
    private final String arrayType;
    private JsonNode discriminatorNode;
    private String discriminatorPropertyName;
    private JsonNode discriminatorMapping;

    DiscriminatorValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema, String arrayType) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.arrayType = arrayType;
        this.setupDiscriminator(context, schemaNode, schemaParentNode, parentSchema);
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.discriminatorNode != null) {
            if ("allOf".equals(this.arrayType)) {
                this.validateAllOf(valueNode, results);
            } else {
                this.validateOneAnyOf(valueNode, results);
            }
        } else {
            this.validateWithoutDiscriminator(valueNode, results);
        }
    }

    private void validateAllOf(JsonNode valueNode, ValidationResults results) {
        String discriminatorPropertyRefPath = this.getDiscriminatorPropertyRefPath(valueNode, results);
        if (discriminatorPropertyRefPath == null) {
            results.addError(String.format(INVALID_SCHEMA, this.discriminatorPropertyName), "discriminator");
            return;
        }
        this.validate(() -> {
            for (SchemaValidator schema : this.schemas) {
                schema.validateWithContext(valueNode, results);
            }
        });
    }

    private void validateOneAnyOf(JsonNode valueNode, ValidationResults results) {
        String discriminatorPropertyRefPath = this.getDiscriminatorPropertyRefPath(valueNode, results);
        if (discriminatorPropertyRefPath == null) {
            results.addError(String.format(INVALID_SCHEMA, this.discriminatorPropertyName), "discriminator");
            return;
        }
        for (SchemaValidator schema : this.schemas) {
            JsonNode refNode = schema.getSchemaNode().get("$ref");
            if (!discriminatorPropertyRefPath.equals(refNode.textValue())) continue;
            this.validate(() -> schema.validateWithContext(valueNode, results));
            return;
        }
        results.addError(String.format(INVALID_SCHEMA, this.discriminatorPropertyName), "discriminator");
    }

    abstract void validateWithoutDiscriminator(JsonNode var1, ValidationResults var2);

    private void setupDiscriminator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        if ("allOf".equals(this.arrayType)) {
            this.setupAllOfDiscriminatorSchemas(context, schemaNode, schemaParentNode, parentSchema);
        } else {
            this.setupAnyOneOfDiscriminatorSchemas(context, schemaNode, schemaParentNode, parentSchema);
        }
        if (this.discriminatorNode != null) {
            JsonNode propertyNameNode = this.discriminatorNode.get("propertyName");
            if (propertyNameNode == null) {
                return;
            }
            this.discriminatorPropertyName = propertyNameNode.textValue();
            this.discriminatorMapping = this.discriminatorNode.get("mapping");
        }
    }

    private void setupAllOfDiscriminatorSchemas(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        JsonNode allOfNode = this.getParentSchemaNode().get("allOf");
        for (int index = 0; index < allOfNode.size(); ++index) {
            JsonNode allOfNodeItem = allOfNode.get(index);
            List refNodes = allOfNodeItem.findValues("abs$ref");
            if (refNodes.isEmpty()) {
                refNodes = allOfNodeItem.findValues("$ref");
            }
            for (JsonNode refNode : refNodes) {
                Reference reference = context.getContext().getReferenceRegistry().getRef(refNode.textValue());
                this.discriminatorNode = reference.getContent().get("discriminator");
                if (this.discriminatorNode == null) continue;
                this.setupAllOfDiscriminatorSchemas(schemaNode, refNode, reference, schemaParentNode, parentSchema);
                return;
            }
        }
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new SchemaValidator(context, this.arrayType, schemaNode.get(i), schemaParentNode, parentSchema));
        }
    }

    private void setupAnyOneOfDiscriminatorSchemas(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        this.discriminatorNode = this.getParentSchemaNode().get("discriminator");
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new SchemaValidator(context, this.arrayType, schemaNode.get(i), schemaParentNode, parentSchema));
        }
    }

    private void setupAllOfDiscriminatorSchemas(JsonNode schemaNode, JsonNode refNode, Reference reference, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode node = schemaNode.get(i);
            JsonNode refValueNode = node.get("$ref");
            if (refNode.equals((Object)refValueNode)) {
                this.schemas.add(new SchemaValidator(this.context, reference.getRef(), reference.getContent(), schemaParentNode, parentSchema));
                continue;
            }
            this.schemas.add(new SchemaValidator(this.context, this.arrayType, node, schemaParentNode, parentSchema));
        }
    }

    private String getDiscriminatorPropertyRefPath(JsonNode valueNode, ValidationResults results) {
        JsonNode mappingNode;
        if (this.discriminatorPropertyName == null) {
            results.addError(INVALID_PROPERTY, "discriminator");
            return null;
        }
        JsonNode discriminatorPropertyNameNode = valueNode.get(this.discriminatorPropertyName);
        if (discriminatorPropertyNameNode == null) {
            results.addError(String.format(INVALID_PROPERTY_CONTENT, this.discriminatorPropertyName), "discriminator");
            return null;
        }
        String discriminatorPropertyValue = discriminatorPropertyNameNode.textValue();
        String ref = SCHEMAS_PATH + discriminatorPropertyValue;
        if (this.discriminatorMapping != null && (mappingNode = this.discriminatorMapping.get(discriminatorPropertyValue)) != null) {
            ref = mappingNode.textValue();
        }
        if (this.context.getContext().getReferenceRegistry().getRef(ref) != null) {
            return ref;
        }
        return null;
    }
}

