/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class ItemsValidator
extends BaseJsonValidator<OAI3> {
    private final SchemaValidator schema;

    static ItemsValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new ItemsValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private ItemsValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.schema = new SchemaValidator(context, "items", schemaNode, schemaParentNode, parentSchema);
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (!valueNode.isArray()) {
            return;
        }
        this.validate(() -> {
            for (JsonNode itemNode : valueNode) {
                this.schema.validateWithContext(itemNode, results);
            }
        });
    }
}

