/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MaxLengthValidator
extends BaseJsonValidator<OAI3> {
    private static final String ERR_MSG = "Max length is '%s', found '%s'.";
    private final Integer maxLength;

    static MaxLengthValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new MaxLengthValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private MaxLengthValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.maxLength = schemaNode.isIntegralNumber() ? Integer.valueOf(schemaNode.intValue()) : null;
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.maxLength == null || !valueNode.isTextual()) {
            return;
        }
        String value = valueNode.textValue();
        int length = value.codePointCount(0, value.length());
        if (length > this.maxLength) {
            results.addError(String.format(ERR_MSG, this.maxLength, length), "maxLength");
        }
    }
}

