/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MaximumValidator
extends BaseJsonValidator<OAI3> {
    private static final String EXCLUSIVE_ERR_MSG = "'%s' cannot be greater than '%s' excluded.";
    private static final String ERR_MSG = "'%s' cannot be greater than '%s'.";
    private final BigDecimal maximum;
    private final boolean excludeEqual;

    static MaximumValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new MaximumValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private MaximumValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.maximum = schemaNode.isNumber() ? schemaNode.decimalValue() : null;
        JsonNode exclusiveMaximumNode = schemaParentNode.get("exclusiveMaximum");
        this.excludeEqual = exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean() ? exclusiveMaximumNode.booleanValue() : false;
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.maximum == null || !valueNode.isNumber()) {
            return;
        }
        BigDecimal value = valueNode.decimalValue();
        int compResult = value.compareTo(this.maximum);
        if (this.excludeEqual && compResult == 0) {
            results.addError(String.format(EXCLUSIVE_ERR_MSG, value, this.maximum), "maximum");
        } else if (compResult > 0) {
            results.addError(String.format(ERR_MSG, value, this.maximum), "maximum");
        }
    }
}

