/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MinPropertiesValidator
extends BaseJsonValidator<OAI3> {
    private static final String ERR_MSG = "Minimum is '%s', found '%s'.";
    private final Integer min;

    static MinPropertiesValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new MinPropertiesValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private MinPropertiesValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.min = schemaNode.isIntegralNumber() ? Integer.valueOf(schemaNode.intValue()) : null;
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.min == null || !valueNode.isObject()) {
            return;
        }
        if (valueNode.size() < this.min) {
            results.addError(String.format(ERR_MSG, this.min, valueNode.size()), "minProperties");
        }
    }
}

