/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MinimumValidator
extends BaseJsonValidator<OAI3> {
    private static final String EXCLUSIVE_ERR_MSG = "'%s' cannot be lower than '%s' excluded.";
    private static final String ERR_MSG = "'%s' cannot be lower than '%s'.";
    private final BigDecimal minimum;
    private final boolean excludeEqual;

    static MinimumValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new MinimumValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private MinimumValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.minimum = schemaNode.isNumber() ? schemaNode.decimalValue() : null;
        JsonNode exclusiveMaximumNode = schemaParentNode.get("exclusiveMinimum");
        this.excludeEqual = exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean() ? exclusiveMaximumNode.booleanValue() : false;
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.minimum == null || !valueNode.isNumber()) {
            return;
        }
        BigDecimal value = valueNode.decimalValue();
        int compResult = value.compareTo(this.minimum);
        if (this.excludeEqual && compResult == 0) {
            results.addError(String.format(EXCLUSIVE_ERR_MSG, value, this.minimum), "minimum");
        } else if (compResult < 0) {
            results.addError(String.format(ERR_MSG, value, this.minimum), "minimum");
        }
    }
}

