/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MultipleOfValidator
extends BaseJsonValidator<OAI3> {
    private static final String ERR_MSG = "Value '%s' is not a multiple of '%s'.";
    private static final BigDecimal DIVISIBLE = BigDecimal.valueOf(0.0);
    private final BigDecimal multiple;

    static MultipleOfValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new MultipleOfValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private MultipleOfValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.multiple = schemaNode.isNumber() && schemaNode.decimalValue().compareTo(DIVISIBLE) > 0 ? schemaNode.decimalValue() : null;
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.multiple == null || !valueNode.isNumber()) {
            return;
        }
        BigDecimal value = valueNode.decimalValue();
        BigDecimal remainder = value.remainder(this.multiple);
        if (remainder.compareTo(DIVISIBLE) != 0) {
            results.addError(String.format(ERR_MSG, value, this.multiple), "multipleOf");
        }
    }
}

