/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class NotValidator
extends BaseJsonValidator<OAI3> {
    private static final String ERR_MSG = "Schema should not be valid.";
    private final SchemaValidator schema;

    static NotValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new NotValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private NotValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.schema = new SchemaValidator(context, "not", schemaNode, schemaParentNode, parentSchema);
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        try {
            this.schema.validate(valueNode);
            results.addError(ERR_MSG, "not");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

