/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class NullableValidator
extends BaseJsonValidator<OAI3> {
    private static final String ERR_MSG = "Null value is not allowed.";
    private final boolean nullable;

    static NullableValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new NullableValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private NullableValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.nullable = schemaNode.isBoolean() && schemaNode.booleanValue();
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (!this.nullable && valueNode.isNull()) {
            results.addError(ERR_MSG, "nullable");
        }
    }
}

