/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.DiscriminatorValidator;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class OneOfValidator
extends DiscriminatorValidator {
    private static final String NO_VALID_SCHEMA_ERR_MSG = "No valid schema.";
    private static final String MANY_VALID_SCHEMA_ERR_MSG = "More than 1 schema is valid.";

    static OneOfValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new OneOfValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private OneOfValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema, "oneOf");
    }

    @Override
    void validateWithoutDiscriminator(JsonNode valueNode, ValidationResults results) {
        int schemasSize = this.schemas.size();
        int nbSchemasOnError = 0;
        for (SchemaValidator schema : this.schemas) {
            try {
                schema.validate(valueNode);
            }
            catch (ValidationException ex) {
                ++nbSchemasOnError;
            }
        }
        if (nbSchemasOnError == schemasSize) {
            results.addError(NO_VALID_SCHEMA_ERR_MSG, "oneOf");
        } else if (schemasSize - nbSchemasOnError > 1) {
            results.addError(MANY_VALID_SCHEMA_ERR_MSG, "oneOf");
        }
    }
}

