/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class PatternPropertiesValidator
extends BaseJsonValidator<OAI3> {
    private final Map<Pattern, SchemaValidator> schemas = new IdentityHashMap<Pattern, SchemaValidator>();

    static PatternPropertiesValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new PatternPropertiesValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private PatternPropertiesValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        Iterator names = schemaNode.fieldNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            this.schemas.put(Pattern.compile(name), new SchemaValidator(context, name, schemaNode.get(name), schemaParentNode, parentSchema));
        }
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (!valueNode.isObject()) {
            return;
        }
        Iterator names = valueNode.fieldNames();
        this.validate(() -> {
            while (names.hasNext()) {
                String name = (String)names.next();
                for (Map.Entry<Pattern, SchemaValidator> entry : this.schemas.entrySet()) {
                    Matcher m = entry.getKey().matcher(name);
                    if (!m.matches()) continue;
                    entry.getValue().validateWithContext(valueNode.get(name), results);
                }
            }
        });
    }
}

