/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class PatternValidator
extends BaseJsonValidator<OAI3> {
    private static final String PATTERN_DEF_ERR_MSG = "Wrong pattern definition '%s'.";
    private static final String ERR_MSG = "'%s' does not respect pattern '%s'.";
    private final String patternStr;
    private final Pattern pattern;

    static PatternValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new PatternValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private PatternValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.patternStr = schemaNode.asText();
        this.pattern = schemaNode.isTextual() ? Pattern.compile(schemaNode.textValue()) : null;
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.pattern == null) {
            results.addError(String.format(PATTERN_DEF_ERR_MSG, this.patternStr), "pattern");
            return;
        }
        if (!valueNode.isTextual()) {
            return;
        }
        String value = valueNode.textValue();
        Matcher m = this.pattern.matcher(value);
        if (!m.find()) {
            results.addError(String.format(ERR_MSG, value, this.patternStr), "pattern");
        }
    }
}

