/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class RequiredValidator
extends BaseJsonValidator<OAI3> {
    private static final String ERR_MSG = "Field '%s' is required.";
    private final List<String> fieldNames;

    static RequiredValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new RequiredValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private RequiredValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        if (schemaNode.isArray()) {
            this.fieldNames = new ArrayList<String>();
            for (JsonNode fieldName : schemaNode) {
                this.fieldNames.add(fieldName.asText());
            }
        } else {
            this.fieldNames = null;
        }
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (this.fieldNames == null) {
            return;
        }
        for (String fieldName : this.fieldNames) {
            if (null != valueNode.get(fieldName)) continue;
            results.addError(String.format(ERR_MSG, fieldName), "required");
        }
    }
}

