/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.model.v3.OAI3Context;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.ValidatorsRegistry;

public class SchemaValidator
extends BaseJsonValidator<OAI3> {
    private static final JsonNode FALSE_NODE = JsonNodeFactory.instance.booleanNode(false);
    private final String propertyName;
    private final Map<String, JsonValidator> validators;

    public SchemaValidator(String propertyName, JsonNode schemaNode) throws ResolutionException {
        super(null, schemaNode, null, null);
        OAI3Context apiContext = new OAI3Context(URI.create("/"), schemaNode);
        this.context = new ValidationContext((OAIContext)apiContext);
        this.propertyName = propertyName;
        this.validators = this.read(this.context, schemaNode);
    }

    public SchemaValidator(ValidationContext<OAI3> context, String propertyName, JsonNode schemaNode) {
        this(context, propertyName, schemaNode, null, null);
    }

    public SchemaValidator(ValidationContext<OAI3> context, String propertyName, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.propertyName = propertyName;
        this.validators = this.read(this.context, schemaNode);
    }

    public ValidationContext<OAI3> getContext() {
        return this.context;
    }

    SchemaValidator findParent() {
        return this.getParentSchema() != null ? this.getParentSchema().findParent() : this;
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        try {
            this.validateWithContext(valueNode, results);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    final void validateWithContext(JsonNode valueNode, ValidationResults results) throws ValidationException {
        if (valueNode == null) {
            valueNode = JsonNodeFactory.instance.nullNode();
        }
        if (this.context.isFastFail()) {
            this.fastFailValidate(valueNode, results);
        } else {
            this.defaultValidate(valueNode, results);
        }
    }

    private void fastFailValidate(JsonNode valueNode, ValidationResults results) throws ValidationException {
        results.withCrumb(this.propertyName, () -> {
            for (JsonValidator validator : this.validators.values()) {
                validator.validate(valueNode, results);
                if (results.isValid()) continue;
                return;
            }
        });
        if (!results.isValid()) {
            throw new ValidationException(null, results);
        }
    }

    private void defaultValidate(JsonNode valueNode, ValidationResults results) {
        results.withCrumb(this.propertyName, () -> {
            for (JsonValidator validator : this.validators.values()) {
                validator.validate(valueNode, results);
            }
        });
    }

    private Map<String, JsonValidator> read(ValidationContext<OAI3> context, JsonNode schemaNode) {
        HashMap<String, JsonValidator> validatorMap = new HashMap<String, JsonValidator>();
        Iterator fieldNames = schemaNode.fieldNames();
        while (fieldNames.hasNext()) {
            String keyword = (String)fieldNames.next();
            JsonNode keywordSchemaNode = schemaNode.get(keyword);
            JsonValidator validator = ValidatorsRegistry.instance().getValidator(context, keyword, keywordSchemaNode, schemaNode, this);
            if (validator == null) continue;
            validatorMap.put(keyword, validator);
        }
        if (validatorMap.get("additionalProperties") == null && context.getOption((byte)1)) {
            validatorMap.put("additionalProperties", ValidatorsRegistry.instance().getValidator(context, "additionalProperties", FALSE_NODE, schemaNode, this));
        }
        validatorMap.computeIfAbsent("nullable", s -> ValidatorsRegistry.instance().getValidator(context, (String)s, FALSE_NODE, schemaNode, this));
        return validatorMap;
    }
}

