/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class TypeValidator
extends BaseJsonValidator<OAI3> {
    private static final String ERR_MSG = "Type expected '%s', found '%s'.";
    private static final String TYPE_NULL = "null";
    private final String type;

    static TypeValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new TypeValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private TypeValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.type = schemaNode.textValue();
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        String valueType = this.getTypeFromValue(valueNode);
        if (!valueType.equals(this.type)) {
            if ("number".equals(this.type) && "integer".equals(valueType)) {
                return;
            }
            if (!TYPE_NULL.equals(valueType)) {
                results.addError(String.format(ERR_MSG, this.type, valueType), "type");
            }
        }
    }

    private String getTypeFromValue(JsonNode valueNode) {
        if (valueNode.isContainerNode()) {
            return valueNode.isObject() ? "object" : "array";
        }
        if (valueNode.isTextual()) {
            return "string";
        }
        if (valueNode.isIntegralNumber()) {
            return "integer";
        }
        if (valueNode.isNumber()) {
            return "number";
        }
        if (valueNode.isBoolean()) {
            return "boolean";
        }
        return TYPE_NULL;
    }
}

