/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class UniqueItemsValidator
extends BaseJsonValidator<OAI3> {
    private static final String INVALID_UNIQUENESS = "Uniqueness is not respected '%s'.";
    private final boolean unique;

    static UniqueItemsValidator create(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        return new UniqueItemsValidator(context, schemaNode, schemaParentNode, parentSchema);
    }

    private UniqueItemsValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.unique = schemaNode.isBoolean() && schemaNode.booleanValue();
    }

    @Override
    public void validate(JsonNode valueNode, ValidationResults results) {
        if (!this.unique) {
            return;
        }
        HashSet<JsonNode> set = new HashSet<JsonNode>();
        for (JsonNode n : valueNode) {
            if (set.add(n)) continue;
            results.addError(String.format(INVALID_UNIQUENESS, n.asText()), "uniqueItems");
        }
    }
}

