/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.v3.AdditionalPropertiesValidator;
import org.openapi4j.schema.validator.v3.AllOfValidator;
import org.openapi4j.schema.validator.v3.AnyOfValidator;
import org.openapi4j.schema.validator.v3.DependenciesValidator;
import org.openapi4j.schema.validator.v3.EnumValidator;
import org.openapi4j.schema.validator.v3.FormatValidator;
import org.openapi4j.schema.validator.v3.ItemsValidator;
import org.openapi4j.schema.validator.v3.MaxItemsValidator;
import org.openapi4j.schema.validator.v3.MaxLengthValidator;
import org.openapi4j.schema.validator.v3.MaxPropertiesValidator;
import org.openapi4j.schema.validator.v3.MaximumValidator;
import org.openapi4j.schema.validator.v3.MinItemsValidator;
import org.openapi4j.schema.validator.v3.MinLengthValidator;
import org.openapi4j.schema.validator.v3.MinPropertiesValidator;
import org.openapi4j.schema.validator.v3.MinimumValidator;
import org.openapi4j.schema.validator.v3.MultipleOfValidator;
import org.openapi4j.schema.validator.v3.NotValidator;
import org.openapi4j.schema.validator.v3.NullableValidator;
import org.openapi4j.schema.validator.v3.OneOfValidator;
import org.openapi4j.schema.validator.v3.PatternPropertiesValidator;
import org.openapi4j.schema.validator.v3.PatternValidator;
import org.openapi4j.schema.validator.v3.PropertiesValidator;
import org.openapi4j.schema.validator.v3.ReferenceValidator;
import org.openapi4j.schema.validator.v3.RequiredValidator;
import org.openapi4j.schema.validator.v3.SchemaValidator;
import org.openapi4j.schema.validator.v3.TypeValidator;
import org.openapi4j.schema.validator.v3.UniqueItemsValidator;
import org.openapi4j.schema.validator.v3.ValidatorInstance;

class ValidatorsRegistry {
    private static final ValidatorsRegistry INSTANCE = new ValidatorsRegistry();
    private final Map<String, ValidatorInstance> validators = new HashMap<String, ValidatorInstance>();

    private ValidatorsRegistry() {
        this.validators.put("additionalProperties", AdditionalPropertiesValidator::create);
        this.validators.put("allOf", AllOfValidator::create);
        this.validators.put("anyOf", AnyOfValidator::create);
        this.validators.put("dependencies", DependenciesValidator::create);
        this.validators.put("enum", EnumValidator::create);
        this.validators.put("format", FormatValidator::create);
        this.validators.put("items", ItemsValidator::create);
        this.validators.put("maximum", MaximumValidator::create);
        this.validators.put("maxItems", MaxItemsValidator::create);
        this.validators.put("maxLength", MaxLengthValidator::create);
        this.validators.put("maxProperties", MaxPropertiesValidator::create);
        this.validators.put("minimum", MinimumValidator::create);
        this.validators.put("minItems", MinItemsValidator::create);
        this.validators.put("minLength", MinLengthValidator::create);
        this.validators.put("minProperties", MinPropertiesValidator::create);
        this.validators.put("multipleOf", MultipleOfValidator::create);
        this.validators.put("not", NotValidator::create);
        this.validators.put("nullable", NullableValidator::create);
        this.validators.put("oneOf", OneOfValidator::create);
        this.validators.put("pattern", PatternValidator::create);
        this.validators.put("patternProperties", PatternPropertiesValidator::create);
        this.validators.put("properties", PropertiesValidator::create);
        this.validators.put("$ref", ReferenceValidator::create);
        this.validators.put("required", RequiredValidator::create);
        this.validators.put("type", TypeValidator::create);
        this.validators.put("uniqueItems", UniqueItemsValidator::create);
    }

    static ValidatorsRegistry instance() {
        return INSTANCE;
    }

    JsonValidator getValidator(ValidationContext<OAI3> context, String keyword, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        ValidatorInstance evi = context.getValidators().get(keyword);
        if (evi != null) {
            return evi.apply(context, schemaNode, schemaParentNode, parentSchema);
        }
        evi = this.validators.get(keyword);
        if (evi != null) {
            return evi.apply(context, schemaNode, schemaParentNode, parentSchema);
        }
        return null;
    }
}

