/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.SemVer;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptAngularClientCodegen
extends AbstractTypeScriptClientCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(TypeScriptAngularClientCodegen.class);
    private static String CLASS_NAME_PREFIX_PATTERN = "^[a-zA-Z0-9]*$";
    private static String CLASS_NAME_SUFFIX_PATTERN = "^[a-zA-Z0-9]*$";
    private static String FILE_NAME_SUFFIX_PATTERN = "^[a-zA-Z0-9.-]*$";
    private static final String DEFAULT_IMPORT_PREFIX = "./";
    private static final String DEFAULT_MODEL_IMPORT_DIRECTORY_PREFIX = "../";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String USE_SINGLE_REQUEST_PARAMETER = "useSingleRequestParameter";
    public static final String TAGGED_UNIONS = "taggedUnions";
    public static final String NG_VERSION = "ngVersion";
    public static final String PROVIDED_IN = "providedIn";
    public static final String ENFORCE_GENERIC_MODULE_WITH_PROVIDERS = "enforceGenericModuleWithProviders";
    public static final String HTTP_CONTEXT_IN_OPTIONS = "httpContextInOptions";
    public static final String API_MODULE_PREFIX = "apiModulePrefix";
    public static final String CONFIGURATION_PREFIX = "configurationPrefix";
    public static final String SERVICE_SUFFIX = "serviceSuffix";
    public static final String SERVICE_FILE_SUFFIX = "serviceFileSuffix";
    public static final String MODEL_SUFFIX = "modelSuffix";
    public static final String MODEL_FILE_SUFFIX = "modelFileSuffix";
    public static final String FILE_NAMING = "fileNaming";
    public static final String STRING_ENUMS = "stringEnums";
    public static final String STRING_ENUMS_DESC = "Generate string enums instead of objects for enum values.";
    public static final String QUERY_PARAM_OBJECT_FORMAT = "queryParamObjectFormat";
    protected String ngVersion = "16.1.2";
    protected String npmRepository = null;
    private boolean useSingleRequestParameter = false;
    protected String serviceSuffix = "Service";
    protected String serviceFileSuffix = ".service";
    protected String modelSuffix = "";
    protected String modelFileSuffix = "";
    protected String fileNaming = "camelCase";
    protected Boolean stringEnums = false;
    protected QUERY_PARAM_OBJECT_FORMAT_TYPE queryParamObjectFormat = QUERY_PARAM_OBJECT_FORMAT_TYPE.dot;
    protected PROVIDED_IN_LEVEL providedIn = PROVIDED_IN_LEVEL.root;
    private boolean taggedUnions = false;

    public TypeScriptAngularClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterStyling}));
        this.outputFolder = "generated-code/typescript-angular";
        this.supportsMultipleInheritance = true;
        this.templateDir = "typescript-angular";
        this.embeddedTemplateDir = "typescript-angular";
        this.modelTemplateFiles.put("model.mustache", ".ts");
        this.apiTemplateFiles.put("api.service.mustache", ".ts");
        this.languageSpecificPrimitives.add("Blob");
        this.typeMapping.put("file", "Blob");
        this.apiPackage = "api";
        this.modelPackage = "model";
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(CliOption.newBoolean(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", false));
        this.cliOptions.add(CliOption.newBoolean(USE_SINGLE_REQUEST_PARAMETER, "Setting this property to true will generate functions with a single argument containing all API endpoint parameters instead of one argument per parameter.", false));
        this.cliOptions.add(CliOption.newBoolean(TAGGED_UNIONS, "Use discriminators to create tagged unions instead of extending interfaces.", this.taggedUnions));
        CliOption providedInCliOpt = new CliOption(PROVIDED_IN, "Use this property to provide Injectables in wanted level.").defaultValue("root");
        HashMap<String, String> providedInOptions = new HashMap<String, String>();
        providedInOptions.put(PROVIDED_IN_LEVEL.none.toString(), "No providedIn)");
        providedInOptions.put(PROVIDED_IN_LEVEL.root.toString(), "The application-level injector in most apps.");
        providedInOptions.put(PROVIDED_IN_LEVEL.platform.toString(), "A special singleton platform injector shared by all applications on the page.");
        providedInOptions.put(PROVIDED_IN_LEVEL.any.toString(), "Provides a unique instance in each lazy loaded module while all eagerly loaded modules share one instance.");
        providedInCliOpt.setEnum(providedInOptions);
        this.cliOptions.add(providedInCliOpt);
        this.cliOptions.add(new CliOption(NG_VERSION, "The version of Angular. (At least 9.0.0)").defaultValue(this.ngVersion));
        this.cliOptions.add(new CliOption(API_MODULE_PREFIX, "The prefix of the generated ApiModule."));
        this.cliOptions.add(new CliOption(CONFIGURATION_PREFIX, "The prefix of the generated Configuration."));
        this.cliOptions.add(new CliOption(SERVICE_SUFFIX, "The suffix of the generated service.").defaultValue(this.serviceSuffix));
        this.cliOptions.add(new CliOption(SERVICE_FILE_SUFFIX, "The suffix of the file of the generated service (service<suffix>.ts).").defaultValue(this.serviceFileSuffix));
        this.cliOptions.add(new CliOption(MODEL_SUFFIX, "The suffix of the generated model."));
        this.cliOptions.add(new CliOption(MODEL_FILE_SUFFIX, "The suffix of the file of the generated model (model<suffix>.ts)."));
        this.cliOptions.add(new CliOption(FILE_NAMING, "Naming convention for the output files: 'camelCase', 'kebab-case'.").defaultValue(this.fileNaming));
        this.cliOptions.add(new CliOption(STRING_ENUMS, STRING_ENUMS_DESC).defaultValue(String.valueOf(this.stringEnums)));
        this.cliOptions.add(new CliOption(QUERY_PARAM_OBJECT_FORMAT, "The format for query param objects: 'dot', 'json', 'key'.").defaultValue(this.queryParamObjectFormat.name()));
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public String getName() {
        return "typescript-angular";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript Angular (9.x - 16.x) client library.";
    }

    @Override
    public void processOpts() {
        boolean withInterfaces;
        SemVer ngVersion;
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("models.mustache", this.modelPackage().replace('.', File.separatorChar), "models.ts"));
        this.supportingFiles.add(new SupportingFile("apis.mustache", this.apiPackage().replace('.', File.separatorChar), "api.ts"));
        this.supportingFiles.add(new SupportingFile("index.mustache", this.getIndexDirectory(), "index.ts"));
        this.supportingFiles.add(new SupportingFile("api.module.mustache", this.getIndexDirectory(), "api.module.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", this.getIndexDirectory(), "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("variables.mustache", this.getIndexDirectory(), "variables.ts"));
        this.supportingFiles.add(new SupportingFile("encoder.mustache", this.getIndexDirectory(), "encoder.ts"));
        this.supportingFiles.add(new SupportingFile("param.mustache", this.getIndexDirectory(), "param.ts"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.getIndexDirectory(), "README.md"));
        if (this.additionalProperties.containsKey(NG_VERSION)) {
            ngVersion = new SemVer(this.additionalProperties.get(NG_VERSION).toString());
        } else {
            ngVersion = new SemVer(this.ngVersion);
            this.LOGGER.info("generating code for Angular {} ...", (Object)ngVersion);
            this.LOGGER.info("  (you can select the angular version by setting the additionalProperties (--additional-properties in CLI) ngVersion)");
        }
        if (!ngVersion.atLeast("9.0.0")) {
            throw new IllegalArgumentException("Invalid ngVersion: " + ngVersion + ". Only Angular v9+ is supported.");
        }
        if (this.additionalProperties.containsKey("npmName")) {
            this.addNpmPackageGeneration(ngVersion);
        }
        if (this.additionalProperties.containsKey(STRING_ENUMS)) {
            this.setStringEnums(Boolean.parseBoolean(this.additionalProperties.get(STRING_ENUMS).toString()));
            this.additionalProperties.put(STRING_ENUMS, this.getStringEnums());
            if (this.getStringEnums().booleanValue()) {
                this.classEnumSeparator = "";
            }
        }
        if (this.additionalProperties.containsKey(WITH_INTERFACES) && (withInterfaces = Boolean.parseBoolean(this.additionalProperties.get(WITH_INTERFACES).toString()))) {
            this.apiTemplateFiles.put("apiInterface.mustache", "Interface.ts");
        }
        if (this.additionalProperties.containsKey(USE_SINGLE_REQUEST_PARAMETER)) {
            this.setUseSingleRequestParameter(this.convertPropertyToBoolean(USE_SINGLE_REQUEST_PARAMETER));
        }
        this.writePropertyBack(USE_SINGLE_REQUEST_PARAMETER, this.getUseSingleRequestParameter());
        if (this.additionalProperties.containsKey(TAGGED_UNIONS)) {
            this.taggedUnions = Boolean.parseBoolean(this.additionalProperties.get(TAGGED_UNIONS).toString());
        }
        if (this.additionalProperties.containsKey(PROVIDED_IN)) {
            this.setProvidedIn(this.additionalProperties.get(PROVIDED_IN).toString());
        }
        this.additionalProperties.put(PROVIDED_IN, this.providedIn);
        this.additionalProperties.put("isProvidedInNone", this.getIsProvidedInNone());
        this.additionalProperties.put(ENFORCE_GENERIC_MODULE_WITH_PROVIDERS, true);
        if (ngVersion.atLeast("12.0.0")) {
            this.additionalProperties.put(HTTP_CONTEXT_IN_OPTIONS, true);
        }
        this.additionalProperties.put(NG_VERSION, ngVersion);
        if (this.additionalProperties.containsKey(API_MODULE_PREFIX)) {
            String apiModulePrefix = this.additionalProperties.get(API_MODULE_PREFIX).toString();
            this.validateClassPrefixArgument("ApiModule", apiModulePrefix);
            this.additionalProperties.put("apiModuleClassName", apiModulePrefix + "ApiModule");
        } else {
            this.additionalProperties.put("apiModuleClassName", "ApiModule");
        }
        if (this.additionalProperties.containsKey(CONFIGURATION_PREFIX)) {
            String configurationPrefix = this.additionalProperties.get(CONFIGURATION_PREFIX).toString();
            this.validateClassPrefixArgument("Configuration", configurationPrefix);
            this.additionalProperties.put("configurationClassName", configurationPrefix + "Configuration");
            this.additionalProperties.put("configurationParametersInterfaceName", configurationPrefix + "ConfigurationParameters");
        } else {
            this.additionalProperties.put("configurationClassName", "Configuration");
            this.additionalProperties.put("configurationParametersInterfaceName", "ConfigurationParameters");
        }
        if (this.additionalProperties.containsKey(SERVICE_SUFFIX)) {
            this.serviceSuffix = this.additionalProperties.get(SERVICE_SUFFIX).toString();
            this.validateClassSuffixArgument("Service", this.serviceSuffix);
        }
        if (this.additionalProperties.containsKey(SERVICE_FILE_SUFFIX)) {
            this.serviceFileSuffix = this.additionalProperties.get(SERVICE_FILE_SUFFIX).toString();
            this.validateFileSuffixArgument("Service", this.serviceFileSuffix);
        }
        if (this.additionalProperties.containsKey(MODEL_SUFFIX)) {
            this.modelSuffix = this.additionalProperties.get(MODEL_SUFFIX).toString();
            this.validateClassSuffixArgument("Model", this.modelSuffix);
        }
        if (this.additionalProperties.containsKey(MODEL_FILE_SUFFIX)) {
            this.modelFileSuffix = this.additionalProperties.get(MODEL_FILE_SUFFIX).toString();
            this.validateFileSuffixArgument("Model", this.modelFileSuffix);
        }
        if (this.additionalProperties.containsKey(FILE_NAMING)) {
            this.setFileNaming(this.additionalProperties.get(FILE_NAMING).toString());
        }
        if (this.additionalProperties.containsKey(QUERY_PARAM_OBJECT_FORMAT)) {
            this.setQueryParamObjectFormat((String)this.additionalProperties.get(QUERY_PARAM_OBJECT_FORMAT));
        }
        this.additionalProperties.put("isQueryParamObjectFormatDot", this.getQueryParamObjectFormatDot());
        this.additionalProperties.put("isQueryParamObjectFormatJson", this.getQueryParamObjectFormatJson());
        this.additionalProperties.put("isQueryParamObjectFormatKey", this.getQueryParamObjectFormatKey());
    }

    private void addNpmPackageGeneration(SemVer ngVersion) {
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        if (ngVersion.atLeast("16.1.0")) {
            this.additionalProperties.put("tsVersion", ">=4.9.3 <5.2.0");
        } else if (ngVersion.atLeast("16.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.9.3 <5.1.0");
        } else if (ngVersion.atLeast("15.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.8.2 <4.10.0");
        } else if (ngVersion.atLeast("14.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.6.0 <=4.8.0");
        } else if (ngVersion.atLeast("13.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.4.2 <4.5.0");
        } else if (ngVersion.atLeast("12.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.3.0 <4.4.0");
        } else if (ngVersion.atLeast("11.0.0")) {
            this.additionalProperties.put("tsVersion", ">=4.0.0 <4.1.0");
        } else if (ngVersion.atLeast("10.0.0")) {
            this.additionalProperties.put("tsVersion", ">=3.9.2 <4.0.0");
        } else if (ngVersion.atLeast("9.0.0")) {
            this.additionalProperties.put("tsVersion", ">=3.6.0 <3.8.0");
        } else {
            throw new IllegalArgumentException("Invalid ngVersion. Only Angular v9+ is supported.");
        }
        if (ngVersion.atLeast("16.0.0")) {
            this.additionalProperties.put("rxjsVersion", "7.4.0");
        } else if (ngVersion.atLeast("15.0.0")) {
            this.additionalProperties.put("rxjsVersion", "7.5.5");
        } else if (ngVersion.atLeast("14.0.0")) {
            this.additionalProperties.put("rxjsVersion", "7.5.5");
        } else if (ngVersion.atLeast("13.0.0")) {
            this.additionalProperties.put("rxjsVersion", "7.4.0");
        } else if (ngVersion.atLeast("10.0.0")) {
            this.additionalProperties.put("rxjsVersion", "6.6.0");
        } else if (ngVersion.atLeast("9.0.0")) {
            this.additionalProperties.put("rxjsVersion", "6.5.3");
        }
        this.supportingFiles.add(new SupportingFile("ng-package.mustache", this.getIndexDirectory(), "ng-package.json"));
        if (ngVersion.atLeast("16.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "16.0.0");
        } else if (ngVersion.atLeast("15.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "15.0.2");
        } else if (ngVersion.atLeast("14.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "14.0.2");
            this.additionalProperties.put("tsickleVersion", "0.46.3");
        } else if (ngVersion.atLeast("13.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "13.0.3");
            this.additionalProperties.put("tsickleVersion", "0.43.0");
        } else if (ngVersion.atLeast("12.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "12.2.1");
            this.additionalProperties.put("tsickleVersion", "0.43.0");
        } else if (ngVersion.atLeast("11.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "11.0.2");
            this.additionalProperties.put("tsickleVersion", "0.39.1");
        } else if (ngVersion.atLeast("10.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "10.0.3");
            this.additionalProperties.put("tsickleVersion", "0.39.1");
        } else if (ngVersion.atLeast("9.0.0")) {
            this.additionalProperties.put("ngPackagrVersion", "9.0.1");
            this.additionalProperties.put("tsickleVersion", "0.38.0");
        }
        if (ngVersion.atLeast("16.0.0")) {
            this.additionalProperties.put("zonejsVersion", "0.13.0");
        } else if (ngVersion.atLeast("15.0.0")) {
            this.additionalProperties.put("zonejsVersion", "0.11.5");
        } else if (ngVersion.atLeast("14.0.0")) {
            this.additionalProperties.put("zonejsVersion", "0.11.5");
        } else if (ngVersion.atLeast("12.0.0")) {
            this.additionalProperties.put("zonejsVersion", "0.11.4");
        } else if (ngVersion.atLeast("11.0.0")) {
            this.additionalProperties.put("zonejsVersion", "0.11.3");
        } else if (ngVersion.atLeast("9.0.0")) {
            this.additionalProperties.put("zonejsVersion", "0.10.2");
        } else if (ngVersion.atLeast("8.0.0")) {
            this.additionalProperties.put("zonejsVersion", "0.9.1");
        }
        this.supportingFiles.add(new SupportingFile("package.mustache", this.getIndexDirectory(), "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", this.getIndexDirectory(), "tsconfig.json"));
    }

    private String getIndexDirectory() {
        String indexPackage = this.modelPackage.substring(0, Math.max(0, this.modelPackage.lastIndexOf(46)));
        return indexPackage.replace('.', File.separatorChar);
    }

    public void setStringEnums(boolean value) {
        this.stringEnums = value;
    }

    public Boolean getStringEnums() {
        return this.stringEnums;
    }

    public boolean getQueryParamObjectFormatDot() {
        return QUERY_PARAM_OBJECT_FORMAT_TYPE.dot.equals((Object)this.queryParamObjectFormat);
    }

    public boolean getQueryParamObjectFormatJson() {
        return QUERY_PARAM_OBJECT_FORMAT_TYPE.json.equals((Object)this.queryParamObjectFormat);
    }

    public boolean getQueryParamObjectFormatKey() {
        return QUERY_PARAM_OBJECT_FORMAT_TYPE.key.equals((Object)this.queryParamObjectFormat);
    }

    @Override
    public boolean isDataTypeFile(String dataType) {
        return "Blob".equals(dataType);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isFileSchema(p)) {
            return "Blob";
        }
        return super.getTypeDeclaration(p);
    }

    private String applyLocalTypeMapping(String type) {
        if (this.typeMapping.containsKey(type)) {
            type = (String)this.typeMapping.get(type);
        }
        return type;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        parameter.dataType = this.applyLocalTypeMapping(parameter.dataType);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap operations, List<ModelMap> allModels) {
        OperationMap objs = operations.getOperations();
        objs.put("apiFilename", this.getApiFilenameFromClassname(objs.getClassname()));
        List<CodegenOperation> ops = objs.getOperation();
        boolean hasSomeFormParams = false;
        boolean hasSomeEncodableParams = false;
        for (CodegenOperation op : ops) {
            if (op.getHasFormParams()) {
                hasSomeFormParams = true;
            }
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ENGLISH);
            StringBuilder pathBuffer = new StringBuilder();
            AbstractTypeScriptClientCodegen.ParameterExpander paramExpander = new AbstractTypeScriptClientCodegen.ParameterExpander(op, this::toParamName);
            int insideCurly = 0;
            block5: for (int i = 0; i < op.path.length(); ++i) {
                switch (op.path.charAt(i)) {
                    case '{': {
                        ++insideCurly;
                        continue block5;
                    }
                    case '}': {
                        --insideCurly;
                        pathBuffer.append(paramExpander.buildPathEntry());
                        hasSomeEncodableParams = true;
                        continue block5;
                    }
                    default: {
                        char nextChar = op.path.charAt(i);
                        if (insideCurly > 0) {
                            paramExpander.appendToParameterName(nextChar);
                            continue block5;
                        }
                        pathBuffer.append(nextChar);
                    }
                }
            }
            op.path = pathBuffer.toString();
        }
        operations.put("hasSomeFormParams", hasSomeFormParams);
        operations.put("hasSomeEncodableParams", hasSomeEncodableParams);
        List<Map<String, String>> imports = operations.getImports();
        for (Map<String, String> im : imports) {
            im.put("filename", im.get("import"));
            im.put("classname", im.get("classname"));
        }
        return operations;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        ModelsMap result = super.postProcessModels(objs);
        return this.postProcessModelsEnum(result);
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> result = super.postProcessAllModels(objs);
        for (ModelsMap entry : result.values()) {
            for (ModelMap mo : entry.getModels()) {
                CodegenModel cm = mo.getModel();
                if (this.taggedUnions) {
                    mo.put(TAGGED_UNIONS, true);
                    if (cm.discriminator != null && cm.children != null) {
                        for (CodegenModel child : cm.children) {
                            cm.imports.add(child.classname);
                            this.setChildDiscriminatorValue(cm, child);
                        }
                    }
                    if (cm.parent != null) {
                        cm.imports.remove(cm.parent);
                        for (CodegenProperty cp : cm.allVars) {
                            this.addImportsForPropertyType(cm, cp);
                        }
                        this.removeSelfReferenceImports(cm);
                    }
                }
                Set<String> parsedImports = this.parseImports(cm);
                mo.put("tsImports", this.toTsImports(cm, parsedImports));
            }
        }
        return result;
    }

    private void setChildDiscriminatorValue(CodegenModel parent, CodegenModel child) {
        if (child.vendorExtensions.isEmpty() || !child.vendorExtensions.containsKey("x-discriminator-value")) {
            for (CodegenProperty prop : child.allVars) {
                if (!prop.baseName.equals(parent.discriminator.getPropertyName())) continue;
                for (CodegenDiscriminator.MappedModel mappedModel : parent.discriminator.getMappedModels()) {
                    if (!mappedModel.getModelName().equals(child.classname)) continue;
                    prop.discriminatorValue = mappedModel.getMappingName();
                }
            }
        }
    }

    private Set<String> parseImports(CodegenModel cm) {
        HashSet<String> newImports = new HashSet<String>();
        if (cm.imports.size() > 0) {
            for (String name : cm.imports) {
                if (name.indexOf(" | ") >= 0) {
                    String[] parts = name.split(" \\| ");
                    Collections.addAll(newImports, parts);
                    continue;
                }
                newImports.add(name);
            }
        }
        return newImports;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.toModelFilename(this.removeModelPrefixSuffix(im)));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        return StringUtils.camelize(name) + this.serviceSuffix;
    }

    @Override
    public String toApiFilename(String name) {
        if (name.length() == 0) {
            return "default.service";
        }
        return this.convertUsingFileNamingConvention(name) + this.serviceFileSuffix;
    }

    @Override
    public String toApiImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return this.apiPackage() + "/" + this.toApiFilename(name);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return DEFAULT_IMPORT_PREFIX + this.convertUsingFileNamingConvention(super.toModelFilename(name)) + this.modelFileSuffix;
    }

    @Override
    public String toModelImport(String name) {
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return DEFAULT_MODEL_IMPORT_DIRECTORY_PREFIX + this.modelPackage() + "/" + this.toModelFilename(this.removeModelPrefixSuffix(name)).substring(DEFAULT_IMPORT_PREFIX.length());
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    private boolean getUseSingleRequestParameter() {
        return this.useSingleRequestParameter;
    }

    private void setUseSingleRequestParameter(boolean useSingleRequestParameter) {
        this.useSingleRequestParameter = useSingleRequestParameter;
    }

    private String getApiFilenameFromClassname(String classname) {
        String name = classname.substring(0, classname.length() - this.serviceSuffix.length());
        return this.toApiFilename(name);
    }

    @Override
    public String toModelName(String name) {
        name = this.addSuffix(name, this.modelSuffix);
        return super.toModelName(name);
    }

    public String removeModelPrefixSuffix(String name) {
        String result = name;
        if (this.modelSuffix.length() > 0 && result.endsWith(this.modelSuffix)) {
            result = result.substring(0, result.length() - this.modelSuffix.length());
        }
        String prefix = org.apache.commons.lang3.StringUtils.capitalize((String)this.modelNamePrefix);
        String suffix = org.apache.commons.lang3.StringUtils.capitalize((String)this.modelNameSuffix);
        if (prefix.length() > 0 && result.startsWith(prefix)) {
            result = result.substring(prefix.length());
        }
        if (suffix.length() > 0 && result.endsWith(suffix)) {
            result = result.substring(0, result.length() - suffix.length());
        }
        return result;
    }

    private void validateFileSuffixArgument(String argument, String value) {
        if (!value.matches(FILE_NAME_SUFFIX_PATTERN)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s file suffix only allows '.', '-' and alphanumeric characters.", argument));
        }
    }

    private void validateClassPrefixArgument(String argument, String value) {
        if (!value.matches(CLASS_NAME_PREFIX_PATTERN)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s class prefix only allows alphanumeric characters.", argument));
        }
    }

    private void validateClassSuffixArgument(String argument, String value) {
        if (!value.matches(CLASS_NAME_SUFFIX_PATTERN)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s class suffix only allows alphanumeric characters.", argument));
        }
    }

    public void setQueryParamObjectFormat(String format) {
        try {
            this.queryParamObjectFormat = QUERY_PARAM_OBJECT_FORMAT_TYPE.valueOf(format);
        }
        catch (IllegalArgumentException e) {
            String values = Stream.of(QUERY_PARAM_OBJECT_FORMAT_TYPE.values()).map(value -> "'" + value.name() + "'").collect(Collectors.joining(", "));
            String msg = String.format(Locale.ROOT, "Invalid query param object format '%s'. Must be one of %s.", format, values);
            throw new IllegalArgumentException(msg);
        }
    }

    private void setFileNaming(String fileNaming) {
        if (!"camelCase".equals(fileNaming) && !"kebab-case".equals(fileNaming)) {
            throw new IllegalArgumentException("Invalid file naming '" + fileNaming + "'. Must be 'camelCase' or 'kebab-case'");
        }
        this.fileNaming = fileNaming;
    }

    private String convertUsingFileNamingConvention(String originalName) {
        String name = this.removeModelPrefixSuffix(originalName);
        name = "kebab-case".equals(this.fileNaming) ? StringUtils.dashize(StringUtils.underscore(name)) : StringUtils.camelize(name, CamelizeOption.LOWERCASE_FIRST_LETTER);
        return name;
    }

    public void setProvidedIn(String level) {
        try {
            this.providedIn = PROVIDED_IN_LEVEL.valueOf(level);
        }
        catch (IllegalArgumentException e) {
            String values = Stream.of(PROVIDED_IN_LEVEL.values()).map(value -> "'" + value.name() + "'").collect(Collectors.joining(", "));
            String msg = String.format(Locale.ROOT, "Invalid providedIn level '%s'. Must be one of %s.", level, values);
            throw new IllegalArgumentException(msg);
        }
    }

    private boolean getIsProvidedInNone() {
        return PROVIDED_IN_LEVEL.none.equals((Object)this.providedIn);
    }

    public static enum PROVIDED_IN_LEVEL {
        none,
        root,
        any,
        platform;

    }

    public static enum QUERY_PARAM_OBJECT_FORMAT_TYPE {
        dot,
        json,
        key;

    }
}

