/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileDocumentManagerBase
extends FileDocumentManager {
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create("HARD_REF_TO_DOCUMENT_KEY");
    public static final Key<Boolean> TRACK_NON_PHYSICAL = Key.create("TRACK_NON_PHYSICAL");
    private static final Key<VirtualFile> FILE_KEY = Key.create("FILE_KEY");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create("BIG_FILE_PREVIEW");
    private static final Object lock = new Object();
    private final Map<VirtualFile, Document> myDocumentCache = ContainerUtil.createConcurrentWeakValueMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file);
        if (document == null) {
            if (!file.isValid() || file.isDirectory() || FileDocumentManagerBase.isBinaryWithoutDecompiler(file)) {
                return null;
            }
            boolean tooLarge = FileUtilRt.isTooLarge(file.getLength());
            if (file.getFileType().isBinary() && tooLarge) {
                return null;
            }
            CharSequence text = this.loadText(file, tooLarge);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)this.createDocument(text, file);
                document.setModificationStamp(file.getModificationStamp());
                FileDocumentManagerBase.setDocumentTooLarge(document, tooLarge);
                FileType fileType = file.getFileType();
                document.setReadOnly(tooLarge || !file.isWritable() || fileType.isBinary());
                if (!(file instanceof LightVirtualFile) && !(file.getFileSystem() instanceof NonPhysicalFileSystem) || Boolean.TRUE.equals(TRACK_NON_PHYSICAL.get(file))) {
                    document.addDocumentListener(this.getDocumentListener());
                }
                if (file instanceof LightVirtualFile) {
                    FileDocumentManagerBase.registerDocument(document, file);
                } else {
                    document.putUserData(FILE_KEY, file);
                    this.cacheDocument(file, document);
                }
            }
            this.fileContentLoaded(file, document);
        }
        return document;
    }

    protected static void setDocumentTooLarge(Document document, boolean tooLarge) {
        document.putUserData(BIG_FILE_PREVIEW, tooLarge ? Boolean.TRUE : null);
    }

    @NotNull
    private CharSequence loadText(@NotNull VirtualFile file, boolean tooLarge) {
        FileViewProvider vp;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(1);
        }
        if (file instanceof LightVirtualFile && (vp = this.findCachedPsiInAnyProject(file)) != null) {
            String string = vp.getPsi(vp.getBaseLanguage()).getText();
            if (string == null) {
                FileDocumentManagerBase.$$$reportNull$$$0(2);
            }
            return string;
        }
        CharSequence charSequence = tooLarge ? LoadTextUtil.loadText((VirtualFile)file, (int)FileDocumentManagerBase.getPreviewCharCount(file)) : LoadTextUtil.loadText((VirtualFile)file);
        if (charSequence == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @NotNull
    protected abstract Document createDocument(@NotNull CharSequence var1, @NotNull VirtualFile var2);

    @Override
    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file) {
        Document hard;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(4);
        }
        return (hard = file.getUserData(HARD_REF_TO_DOCUMENT_KEY)) != null ? hard : this.getDocumentFromCache(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(6);
        }
        if (!(virtualFile instanceof LightVirtualFile) && !(virtualFile.getFileSystem() instanceof NonPhysicalFileSystem)) {
            throw new IllegalArgumentException("Hard-coding file<->document association is permitted for non-physical files only (see FileViewProvider.isPhysical()) to avoid memory leaks. virtualFile=" + virtualFile);
        }
        Object object = lock;
        synchronized (object) {
            document.putUserData(FILE_KEY, virtualFile);
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, document);
        }
    }

    @Override
    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(7);
        }
        return document instanceof FrozenDocument ? null : document.getUserData(FILE_KEY);
    }

    @Override
    public void reloadBinaryFiles() {
        List<VirtualFile> binaries = ContainerUtil.filter(this.myDocumentCache.keySet(), file -> file.getFileType().isBinary());
        FileContentUtilCore.reparseFiles(binaries);
    }

    @Override
    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(8);
        }
        return document.getUserData(BIG_FILE_PREVIEW) == Boolean.TRUE;
    }

    void unbindFileFromDocument(@NotNull VirtualFile file, @NotNull Document document) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(9);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(10);
        }
        this.removeDocumentFromCache(file);
        file.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    protected static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file) {
        FileType type;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(11);
        }
        return (type = file.getFileType()).isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(type) == null;
    }

    protected static int getPreviewCharCount(@NotNull VirtualFile file) {
        Charset charset;
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(12);
        }
        float bytesPerChar = (charset = EncodingManager.getInstance().getEncoding(file, false)) == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        return (int)((float)FileUtilRt.LARGE_FILE_PREVIEW_SIZE / bytesPerChar);
    }

    private void cacheDocument(@NotNull VirtualFile file, @NotNull Document document) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(13);
        }
        if (document == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(14);
        }
        this.myDocumentCache.put(file, document);
    }

    private void removeDocumentFromCache(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(15);
        }
        this.myDocumentCache.remove(file);
    }

    private Document getDocumentFromCache(@NotNull VirtualFile file) {
        if (file == null) {
            FileDocumentManagerBase.$$$reportNull$$$0(16);
        }
        return this.myDocumentCache.get(file);
    }

    @ApiStatus.Internal
    protected void clearDocumentCache() {
        this.myDocumentCache.clear();
    }

    protected abstract void fileContentLoaded(@NotNull VirtualFile var1, @NotNull Document var2);

    @NotNull
    protected abstract DocumentListener getDocumentListener();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileDocumentManagerBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCachedDocument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerDocument";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPartialPreviewOfALargeFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unbindFileFromDocument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isBinaryWithoutDecompiler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPreviewCharCount";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "cacheDocument";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentFromCache";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFromCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

