/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public final class CollectIntelliJDependenciesAsm {
    private final Set<String> visited = new HashSet<String>();

    public static void main(String[] args) {
        new CollectIntelliJDependenciesAsm().run();
    }

    void run() {
        this.processClass("org/openrewrite/python/PythonParser", Kind.ROOT);
    }

    void processClass(String className, Kind kind) {
        ClassReader reader;
        if (className == null) {
            return;
        }
        if (className.startsWith("[")) {
            while (className.startsWith("[")) {
                className = className.substring(1);
            }
            className = className.substring(1);
        }
        while (className.endsWith(";")) {
            className = className.substring(0, className.length() - 1);
        }
        if (className.isEmpty()) {
            return;
        }
        if (!this.visited.add(className)) {
            return;
        }
        try {
            reader = new ClassReader(className);
        }
        catch (IOException e) {
            return;
        }
        URL classfileUrl = this.getClass().getClassLoader().getResource(className + ".class");
        if (classfileUrl != null && classfileUrl.getProtocol().equals("jar")) {
            String jarfile = classfileUrl.getPath().substring(0, classfileUrl.getPath().indexOf("!"));
            System.out.println("class\t" + className + "\t" + jarfile);
        }
        int ASM_VERSION = 589824;
        final SignatureVisitor signatureVisitor = new SignatureVisitor(589824){

            public void visitClassType(String name) {
                CollectIntelliJDependenciesAsm.this.processClass(name, Kind.SIGNATURE);
                super.visitClassType(name);
            }
        };
        final MethodVisitor methodVisitor = new MethodVisitor(589824){

            public void visitTypeInsn(int opcode, String type) {
                CollectIntelliJDependenciesAsm.this.processClass(type, Kind.INSTRUCTION);
                super.visitTypeInsn(opcode, type);
            }
        };
        ClassVisitor visitor = new ClassVisitor(589824){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                if (signature != null) {
                    new SignatureReader(signature).accept(signatureVisitor);
                }
                CollectIntelliJDependenciesAsm.this.processClass(superName, Kind.BASE);
                for (String iface : interfaces) {
                    CollectIntelliJDependenciesAsm.this.processClass(iface, Kind.INTERFACE);
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                if (signature != null) {
                    new SignatureReader(signature).accept(signatureVisitor);
                }
                return methodVisitor;
            }
        };
        reader.accept(visitor, 0);
    }

    static enum Kind {
        ROOT,
        CLASS,
        SIGNATURE,
        INTERFACE,
        BASE,
        INSTRUCTION;

    }
}

